/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.plan.branches;

import com.atlassian.bamboo.specs.api.codegen.CodeEmitter;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.model.plan.branches.CreatePlanBranchesProperties;
import com.atlassian.bamboo.specs.codegen.emitters.ValueEmitterFactory;
import org.jetbrains.annotations.NotNull;

public class CreatePlanBranchesEmitter
implements CodeEmitter<CreatePlanBranchesProperties> {
    @NotNull
    public String emitCode(@NotNull CodeGenerationContext context, @NotNull CreatePlanBranchesProperties value) throws CodeGenerationException {
        switch (value.getTrigger()) {
            case MANUAL: {
                return ".createManually()";
            }
            case PULL_REQUEST: {
                return ".createForPullRequest()";
            }
            case BRANCH: {
                String matchingPattern = value.getMatchingPattern();
                if (".*".equals(matchingPattern)) {
                    return ".createForVcsBranch()";
                }
                CodeEmitter matchingPatternEmitter = ValueEmitterFactory.emitterFor(matchingPattern);
                return ".createForVcsBranchMatching(" + matchingPatternEmitter.emitCode(context, (Object)matchingPattern) + ")";
            }
        }
        throw new CodeGenerationException("Unrecognized plan branch creation trigger: " + value.getTrigger());
    }
}

