/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.repository.viewer;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.repository.viewer.VcsRepositoryViewerProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class FishEyeRepositoryViewerProperties
implements VcsRepositoryViewerProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.repository.atlassian-bamboo-repository-viewers:fisheye");
    private final String fishEyeUrl;
    private final String repositoryName;
    private final String repositoryPath;

    private FishEyeRepositoryViewerProperties() {
        this.fishEyeUrl = null;
        this.repositoryName = null;
        this.repositoryPath = null;
    }

    public FishEyeRepositoryViewerProperties(@NotNull String fishEyeUrl, @NotNull String repositoryName, @Nullable String repositoryPath) throws PropertiesValidationException {
        this.fishEyeUrl = fishEyeUrl;
        this.repositoryName = repositoryName;
        this.repositoryPath = repositoryPath;
        this.validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FishEyeRepositoryViewerProperties)) {
            return false;
        }
        FishEyeRepositoryViewerProperties that = (FishEyeRepositoryViewerProperties)o;
        return Objects.equals(this.getFishEyeUrl(), that.getFishEyeUrl()) && Objects.equals(this.getRepositoryName(), that.getRepositoryName()) && Objects.equals(this.getRepositoryPath(), that.getRepositoryPath());
    }

    public void validate() {
        ValidationContext context = ValidationContext.of((String)"FishEye repository viewer");
        ImporterUtils.checkRequired((ValidationContext)context.with("fishEyeUrl"), (Object)this.fishEyeUrl);
        ImporterUtils.checkRequired((ValidationContext)context.with("repositoryName"), (Object)this.repositoryName);
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    public int hashCode() {
        return Objects.hash(this.getFishEyeUrl(), this.getRepositoryName(), this.getRepositoryPath());
    }

    @NotNull
    public String getFishEyeUrl() {
        return this.fishEyeUrl;
    }

    @NotNull
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Nullable
    public String getRepositoryPath() {
        return this.repositoryPath;
    }
}

