/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.trigger;

import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.CronExpressionClientSideValidator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class ScheduledTriggerProperties
extends TriggerProperties {
    public static final String MODULE_KEY = "com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:schedule";
    private static final AtlassianModuleProperties ATLASSIAN_MODULE = (AtlassianModuleProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)new AtlassianModule("com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:schedule"));
    private final String cronExpression;

    private ScheduledTriggerProperties() {
        this.cronExpression = "0 0 0 ? * *";
    }

    public ScheduledTriggerProperties(String name, String description, boolean isEnabled, @NotNull String cronExpression) throws PropertiesValidationException {
        super(name, description, isEnabled);
        this.cronExpression = cronExpression.trim();
        this.validate();
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_MODULE;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void validate() throws PropertiesValidationException {
        super.validate();
        CronExpressionClientSideValidator.validate((String)this.cronExpression);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScheduledTriggerProperties that = (ScheduledTriggerProperties)((Object)o);
        return Objects.equals(this.cronExpression, that.cronExpression);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cronExpression);
    }
}

