/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.util;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public final class FileUtils {
    private FileUtils() {
    }

    public static String readFileContent(@NotNull Path path, String fileIsNullErrorMessage, String fileReadErrorMessage) {
        ImporterUtils.checkNotNull((String)fileIsNullErrorMessage, (Object)path);
        File file = path.toFile();
        if (!file.exists()) {
            throw new PropertiesValidationException(String.format("File %s does not exist", file.getAbsolutePath()));
        }
        try {
            return new String(Files.readAllBytes(path));
        }
        catch (IOException e) {
            throw new PropertiesValidationException(String.format(fileReadErrorMessage, file.getAbsolutePath()), (Throwable)e);
        }
    }
}

