/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.credentials;

import com.atlassian.bamboo.specs.api.builders.BambooOid;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SharedCredentials<B extends SharedCredentials, C extends SharedCredentialsProperties>
extends EntityPropertiesBuilder<C> {
    protected String name;
    protected BambooOidProperties oid;

    protected SharedCredentials() {
    }

    protected SharedCredentials(@NotNull String name) throws PropertiesValidationException {
        ImporterUtils.checkNotBlank("name", name);
        this.name = name;
    }

    public B name(@NotNull String name) {
        ImporterUtils.checkNotBlank("name", name);
        this.name = name;
        return (B)this;
    }

    public B oid(@Nullable String oid) throws PropertiesValidationException {
        return this.oid(oid != null ? new BambooOid(oid) : null);
    }

    public B oid(@Nullable BambooOid oid) throws PropertiesValidationException {
        this.oid = oid != null ? (BambooOidProperties)EntityPropertiesBuilders.build(oid) : null;
        return (B)this;
    }

    @Override
    protected abstract C build();
}

