/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.plan;

import com.atlassian.bamboo.specs.api.builders.BambooKey;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.plan.artifact.Artifact;
import com.atlassian.bamboo.specs.api.builders.plan.artifact.ArtifactSubscription;
import com.atlassian.bamboo.specs.api.builders.requirement.Requirement;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooKeyProperties;
import com.atlassian.bamboo.specs.api.model.plan.JobProperties;
import com.atlassian.bamboo.specs.api.model.plan.artifact.ArtifactProperties;
import com.atlassian.bamboo.specs.api.model.plan.artifact.ArtifactSubscriptionProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Job
extends EntityPropertiesBuilder<JobProperties> {
    private BambooKeyProperties key;
    private String name;
    private String description = "";
    private boolean enabled = true;
    private List<ArtifactProperties> artifacts = new ArrayList<ArtifactProperties>();
    private List<TaskProperties> tasks = new ArrayList<TaskProperties>();
    private List<TaskProperties> finalTasks = new ArrayList<TaskProperties>();
    private List<RequirementProperties> requirements = new ArrayList<RequirementProperties>();
    private List<ArtifactSubscriptionProperties> subscriptions = new ArrayList<ArtifactSubscriptionProperties>();

    public Job(@NotNull Job copy) {
        this.key = copy.key;
        this.name = copy.name;
        this.description = copy.description;
        this.enabled = copy.enabled;
        this.artifacts.addAll(copy.artifacts);
        this.tasks.addAll(copy.tasks);
        this.finalTasks.addAll(copy.finalTasks);
        this.requirements.addAll(copy.requirements);
    }

    public Job(@NotNull String name, @NotNull String key) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("name", name);
        ImporterUtils.checkNotNull("key", key);
        this.name = name;
        this.key = (BambooKeyProperties)EntityPropertiesBuilders.build(new BambooKey(key));
    }

    public Job(@NotNull String name, @NotNull BambooKey key) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("name", name);
        ImporterUtils.checkNotNull("key", key);
        this.name = name;
        this.key = (BambooKeyProperties)EntityPropertiesBuilders.build(key);
    }

    public Job name(@NotNull String name) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("name", name);
        this.name = name;
        return this;
    }

    public Job key(@NotNull String key) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("key", key);
        return this.key(new BambooKey(key));
    }

    public Job key(@NotNull BambooKey key) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("key", key);
        this.key = (BambooKeyProperties)EntityPropertiesBuilders.build(key);
        return this;
    }

    public Job description(@Nullable String description) throws PropertiesValidationException {
        this.description = description;
        return this;
    }

    public Job enabled(boolean enabled) throws PropertiesValidationException {
        this.enabled = enabled;
        return this;
    }

    public Job artifacts(Artifact ... artifacts) {
        ImporterUtils.checkNotNull("artifacts", artifacts);
        Arrays.stream(artifacts).map(EntityPropertiesBuilders::build).forEach(this.artifacts::add);
        return this;
    }

    public Job artifactSubscriptions(ArtifactSubscription ... subscriptions) {
        ImporterUtils.checkNotNull("subscriptions", subscriptions);
        Arrays.stream(subscriptions).map(EntityPropertiesBuilders::build).forEach(this.subscriptions::add);
        return this;
    }

    public Job tasks(Task<?, ?> ... tasks) {
        ImporterUtils.checkNotNull("tasks", tasks);
        Arrays.stream(tasks).map(EntityPropertiesBuilders::build).forEach(this.tasks::add);
        return this;
    }

    public Job finalTasks(Task<?, ?> ... finalTasks) {
        ImporterUtils.checkNotNull("finalTasks", finalTasks);
        Arrays.stream(finalTasks).map(EntityPropertiesBuilders::build).forEach(this.finalTasks::add);
        return this;
    }

    public Job requirements(Requirement ... requirements) {
        ImporterUtils.checkNotNull("requirements", requirements);
        Arrays.stream(requirements).map(EntityPropertiesBuilders::build).forEach(this.requirements::add);
        return this;
    }

    @NotNull
    public BambooKey getKey() {
        if (this.key == null) {
            throw new IllegalStateException("Job key is undefined");
        }
        return new BambooKey(this.key.getKey());
    }

    @Override
    protected JobProperties build() throws PropertiesValidationException {
        return new JobProperties(this.key, this.name, this.description, this.enabled, this.artifacts, this.tasks, this.finalTasks, this.requirements, this.subscriptions);
    }
}

