/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.plan.branches;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.plan.branches.BranchCleanupProperties;
import java.time.Duration;

public class BranchCleanup
extends EntityPropertiesBuilder<BranchCleanupProperties> {
    public static final int DEFAULT_REMOVED_BRANCH_EXPRIRY_IN_DAYS = 7;
    public static final int DEFAULT_INACTIVE_BRANCH_EXPIRY_IN_DAYS = 30;
    private boolean removeDeletedFromRepository = false;
    private boolean removeInactiveInRepository = false;
    private Duration removeDeletedFromRepositoryPeriod = Duration.ofDays(7L);
    private Duration removeInactiveInRepositoryPeriod = Duration.ofDays(30L);

    public BranchCleanup whenRemovedFromRepository(boolean removeRemovedFromRepository) throws PropertiesValidationException {
        this.removeDeletedFromRepository = removeRemovedFromRepository;
        return this;
    }

    public BranchCleanup whenInactiveInRepository(boolean removeWhenInactiveInRepository) throws PropertiesValidationException {
        this.removeInactiveInRepository = removeWhenInactiveInRepository;
        return this;
    }

    public BranchCleanup whenRemovedFromRepositoryAfterDays(int whenRemovedFromRepositoryAfterDays) throws PropertiesValidationException {
        this.removeDeletedFromRepositoryPeriod = Duration.ofDays(whenRemovedFromRepositoryAfterDays);
        this.removeDeletedFromRepository = true;
        return this;
    }

    public BranchCleanup whenInactiveInRepositoryAfterDays(int whenInactiveInRepositoryAfterDays) throws PropertiesValidationException {
        this.removeInactiveInRepositoryPeriod = Duration.ofDays(whenInactiveInRepositoryAfterDays);
        this.removeInactiveInRepository = true;
        return this;
    }

    @Override
    protected BranchCleanupProperties build() throws PropertiesValidationException {
        return new BranchCleanupProperties(this.removeDeletedFromRepository, this.removeDeletedFromRepositoryPeriod, this.removeInactiveInRepository, this.removeInactiveInRepositoryPeriod);
    }
}

