/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.plan.dependencies;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.plan.dependencies.DependenciesConfigurationProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import org.jetbrains.annotations.NotNull;

public class DependenciesConfiguration
extends EntityPropertiesBuilder<DependenciesConfigurationProperties> {
    private boolean enabledForBranches;
    private boolean requireAllStagesPassing;
    private DependencyBlockingStrategy blockingStrategy = DependencyBlockingStrategy.NONE;

    public DependenciesConfiguration enabledForBranches(boolean enabledForBranches) {
        this.enabledForBranches = enabledForBranches;
        return this;
    }

    public DependenciesConfiguration requireAllStagesPassing(boolean requireAllStagesPassing) {
        this.requireAllStagesPassing = requireAllStagesPassing;
        return this;
    }

    public DependenciesConfiguration blockingStrategy(@NotNull DependencyBlockingStrategy blockingStrategy) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("blockingStrategy", blockingStrategy);
        this.blockingStrategy = blockingStrategy;
        return this;
    }

    @Override
    protected DependenciesConfigurationProperties build() throws PropertiesValidationException {
        return new DependenciesConfigurationProperties(this.enabledForBranches, this.requireAllStagesPassing, this.blockingStrategy);
    }

    public static enum DependencyBlockingStrategy {
        NONE,
        BLOCK_IF_PARENT_IN_PROGRESS,
        BLOCK_IF_PARENT_HAS_CHANGES;

    }
}

