/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.repository;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepository;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepositoryIdentifier;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.repository.PlanRepositoryLinkProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import org.jetbrains.annotations.NotNull;

public class PlanRepositoryLink
extends EntityPropertiesBuilder<PlanRepositoryLinkProperties> {
    private VcsRepositoryProperties repositoryDefinition;

    public static PlanRepositoryLink linkToGlobalRepository(@NotNull VcsRepository globalRepository) {
        return new PlanRepositoryLink().globalRepository(globalRepository);
    }

    public static PlanRepositoryLink linkToGlobalRepository(@NotNull VcsRepositoryIdentifier globalRepository) {
        return new PlanRepositoryLink().localRepositoryDefinition(new LinkedGlobalRepository(globalRepository.build()));
    }

    public PlanRepositoryLink localRepositoryDefinition(@NotNull VcsRepository repositoryDefinition) {
        ImporterUtils.checkNotNull("repositoryDefinition", repositoryDefinition);
        this.repositoryDefinition = repositoryDefinition.build();
        return this;
    }

    public PlanRepositoryLink globalRepository(@NotNull VcsRepository repositoryDefinition) {
        ImporterUtils.checkNotNull("repositoryDefinition", repositoryDefinition);
        this.repositoryDefinition = new LinkedGlobalRepository((VcsRepositoryProperties)repositoryDefinition.build()).build();
        return this;
    }

    @Override
    protected PlanRepositoryLinkProperties build() {
        return new PlanRepositoryLinkProperties(this.repositoryDefinition);
    }

    private static class LinkedGlobalRepository
    extends VcsRepository<LinkedGlobalRepository, PlanRepositoryLinkProperties.LinkedGlobalRepository> {
        private AtlassianModuleProperties atlassianPlugin;

        LinkedGlobalRepository(@NotNull VcsRepositoryProperties globalRepository) {
            this.parent = globalRepository.getName();
            ImporterUtils.checkArgument(ValidationContext.of("Linked global repository"), !globalRepository.hasParent(), "Global repository should not have parent");
            this.atlassianPlugin = globalRepository.getAtlassianPlugin();
        }

        LinkedGlobalRepository(@NotNull VcsRepositoryIdentifierProperties globalRepository) {
            ImporterUtils.checkNotNull("parent", globalRepository);
            this.parent = globalRepository.getName();
        }

        @Override
        protected PlanRepositoryLinkProperties.LinkedGlobalRepository build() {
            return new PlanRepositoryLinkProperties.LinkedGlobalRepository(this.parent, this.atlassianPlugin);
        }
    }
}

