/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.repository;

import com.atlassian.bamboo.specs.api.builders.BambooOid;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepositoryIdentifier;
import com.atlassian.bamboo.specs.api.builders.repository.viewer.VcsRepositoryViewer;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.model.repository.viewer.VcsRepositoryViewerProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsRepository<T extends VcsRepository, E extends VcsRepositoryProperties>
extends EntityPropertiesBuilder<E> {
    protected String parent;
    protected String name;
    protected BambooOidProperties oid;
    protected String description;
    protected VcsRepositoryViewerProperties repositoryViewer;

    public T name(@Nullable String name) throws PropertiesValidationException {
        this.name = name;
        return (T)this;
    }

    public T oid(@Nullable String oid) throws PropertiesValidationException {
        return this.oid(oid != null ? new BambooOid(oid) : null);
    }

    public T oid(@Nullable BambooOid oid) throws PropertiesValidationException {
        this.oid = oid != null ? (BambooOidProperties)EntityPropertiesBuilders.build(oid) : null;
        return (T)this;
    }

    public T parent(@Nullable String parent) throws PropertiesValidationException {
        this.parent = parent;
        return (T)this;
    }

    public T description(@Nullable String description) throws PropertiesValidationException {
        this.description = description;
        return (T)this;
    }

    public T repositoryViewer(@Nullable VcsRepositoryViewer repositoryViewer) throws PropertiesValidationException {
        this.repositoryViewer = repositoryViewer != null ? (VcsRepositoryViewerProperties)EntityPropertiesBuilders.build(repositoryViewer) : null;
        return (T)this;
    }

    @NotNull
    public String getName() {
        if (StringUtils.isBlank((CharSequence)this.name)) {
            throw new IllegalStateException("Repository name is undefined");
        }
        return this.name;
    }

    @NotNull
    public BambooOid getOid() {
        if (this.oid == null) {
            throw new IllegalStateException("Repository oid is undefined");
        }
        return new BambooOid(this.oid.getOid());
    }

    @NotNull
    public VcsRepositoryIdentifier getIdentifier() {
        if (this.oid != null) {
            VcsRepositoryIdentifier identifier = new VcsRepositoryIdentifier(new BambooOid(this.oid.getOid()));
            if (this.name != null) {
                identifier.name(this.name);
            }
            return identifier;
        }
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            VcsRepositoryIdentifier identifier = new VcsRepositoryIdentifier(this.name);
            return identifier;
        }
        throw new IllegalStateException("Repository identifier is undefined");
    }

    @Override
    protected abstract E build() throws PropertiesValidationException;
}

