/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.trigger;

import com.atlassian.bamboo.specs.api.builders.repository.VcsRepositoryIdentifier;
import com.atlassian.bamboo.specs.api.builders.trigger.Trigger;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.trigger.RepositoryBasedTriggerProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class RepositoryBasedTrigger<T extends RepositoryBasedTrigger, P extends RepositoryBasedTriggerProperties>
extends Trigger<T, P> {
    protected List<VcsRepositoryIdentifierProperties> selectedTriggeringRepositories = new ArrayList<VcsRepositoryIdentifierProperties>();
    protected TriggeringRepositoriesType triggeringRepositoriesType = TriggeringRepositoriesType.ALL;

    public T triggeringRepositoriesType(@NotNull TriggeringRepositoriesType triggeringRepositoriesType) {
        ImporterUtils.checkNotNull("triggeringRepositoriesType", triggeringRepositoriesType);
        this.triggeringRepositoriesType = triggeringRepositoriesType;
        return (T)this;
    }

    public T allAvailableTriggeringRepositories() {
        this.triggeringRepositoriesType = TriggeringRepositoriesType.ALL;
        this.selectedTriggeringRepositories.clear();
        return (T)this;
    }

    public T selectedTriggeringRepositories(VcsRepositoryIdentifier ... triggeringRepositories) {
        ImporterUtils.checkNotNull("triggeringRepositories", triggeringRepositories);
        this.triggeringRepositoriesType = TriggeringRepositoriesType.SELECTED;
        for (VcsRepositoryIdentifier moreRepository : triggeringRepositories) {
            this.selectedTriggeringRepositories.add((VcsRepositoryIdentifierProperties)EntityPropertiesBuilders.build(moreRepository));
        }
        return (T)this;
    }

    public static enum TriggeringRepositoriesType {
        ALL,
        SELECTED;

    }
}

