/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.codegen;

import java.util.Set;
import java.util.TreeSet;

public class CodeGenerationContext {
    private int indentationLevel = 0;
    private final Set<String> imports = new TreeSet<String>();

    public void incIndentation() {
        ++this.indentationLevel;
    }

    public void decIndentation() {
        --this.indentationLevel;
    }

    public String importClassName(Class clazz) {
        if (clazz.isMemberClass()) {
            Class<?> enclosingClass = clazz.getEnclosingClass();
            String enclosingClassName = this.importClassName(enclosingClass);
            return enclosingClassName + "." + clazz.getSimpleName();
        }
        this.imports.add(clazz.getCanonicalName());
        return clazz.getSimpleName();
    }

    public String newLine() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        for (int i = 0; i < this.indentationLevel; ++i) {
            builder.append("    ");
        }
        return builder.toString();
    }

    public int getIndentationLevel() {
        return this.indentationLevel;
    }

    public Set<String> getImports() {
        return this.imports;
    }
}

