/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.exceptions;

import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesValidationException
extends RuntimeException {
    private final List<ValidationProblem> errors;

    public PropertiesValidationException(@NotNull String message) {
        this(message, null);
    }

    public PropertiesValidationException(@NotNull String message, @Nullable Throwable cause) {
        this(Collections.singletonList(new ValidationProblem(message)), cause);
    }

    public PropertiesValidationException(@NotNull List<ValidationProblem> errors) {
        this(errors, null);
    }

    public PropertiesValidationException(@NotNull List<ValidationProblem> errors, @Nullable Throwable cause) {
        super(PropertiesValidationException.errorsToMessage(errors), cause);
        this.errors = errors;
    }

    public List<ValidationProblem> getErrors() {
        return this.errors;
    }

    private static String errorsToMessage(@NotNull List<ValidationProblem> errors) {
        return errors.stream().map(ValidationProblem::getMessage).collect(Collectors.joining("\n------------------------------\n"));
    }
}

