/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.plan.artifact;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Immutable
public final class ArtifactProperties
implements EntityProperties {
    private final String name;
    private final String copyPattern;
    private final String location;
    private final boolean shared;

    private ArtifactProperties() {
        this.shared = true;
        this.name = null;
        this.location = "";
        this.copyPattern = null;
    }

    public ArtifactProperties(String name, String copyPattern, String location, boolean shared) throws PropertiesValidationException {
        this.name = name;
        this.copyPattern = copyPattern;
        this.location = location;
        this.shared = shared;
        this.validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactProperties that = (ArtifactProperties)o;
        return this.isShared() == that.isShared() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getCopyPattern(), that.getCopyPattern()) && Objects.equals(this.getLocation(), that.getLocation());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getCopyPattern(), this.getLocation(), this.isShared());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("name", (Object)this.name).append("copyPattern", (Object)this.copyPattern).append("location", (Object)this.location).append("shared", this.shared).build();
    }

    public String getName() {
        return this.name;
    }

    public String getCopyPattern() {
        return this.copyPattern;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isShared() {
        return this.shared;
    }

    @Override
    public void validate() {
    }
}

