/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.plan.branches;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.plan.branch.BranchCreationValidator;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class CreatePlanBranchesProperties
implements EntityProperties {
    public static final String DEFAULT_MATCHING_PATTERN = ".*";
    private Trigger trigger = Trigger.MANUAL;
    private String matchingPattern;

    private CreatePlanBranchesProperties() {
    }

    public CreatePlanBranchesProperties(Trigger trigger, @Nullable String matchingPattern) throws PropertiesValidationException {
        this.trigger = trigger;
        this.matchingPattern = matchingPattern;
        this.validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePlanBranchesProperties that = (CreatePlanBranchesProperties)o;
        return this.getTrigger() == that.getTrigger() && Objects.equals(this.getMatchingPattern(), that.getMatchingPattern());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getTrigger(), this.getMatchingPattern()});
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    @NotNull
    public String getMatchingPattern() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.matchingPattern, (CharSequence)DEFAULT_MATCHING_PATTERN);
    }

    @Override
    public void validate() {
        ImporterUtils.checkNoErrors(BranchCreationValidator.validate(this));
    }

    public static enum Trigger {
        MANUAL,
        PULL_REQUEST,
        BRANCH;

    }
}

