/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.plan.dependencies;

import com.atlassian.bamboo.specs.api.builders.plan.dependencies.DependenciesConfiguration;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class DependenciesConfigurationProperties
implements EntityProperties {
    private final boolean enabledForBranches;
    private final boolean requireAllStagesPassing;
    private final DependenciesConfiguration.DependencyBlockingStrategy blockingStrategy;

    private DependenciesConfigurationProperties() {
        this.enabledForBranches = false;
        this.requireAllStagesPassing = false;
        this.blockingStrategy = DependenciesConfiguration.DependencyBlockingStrategy.NONE;
    }

    public DependenciesConfigurationProperties(boolean enabledForBranches, boolean requireAllStagesPassing, DependenciesConfiguration.DependencyBlockingStrategy blockingStrategy) throws PropertiesValidationException {
        this.enabledForBranches = enabledForBranches;
        this.requireAllStagesPassing = requireAllStagesPassing;
        this.blockingStrategy = blockingStrategy;
        this.validate();
    }

    public boolean isEnabledForBranches() {
        return this.enabledForBranches;
    }

    public boolean isRequireAllStagesPassing() {
        return this.requireAllStagesPassing;
    }

    public DependenciesConfiguration.DependencyBlockingStrategy getBlockingStrategy() {
        return this.blockingStrategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependenciesConfigurationProperties that = (DependenciesConfigurationProperties)o;
        return this.isEnabledForBranches() == that.isEnabledForBranches() && this.isRequireAllStagesPassing() == that.isRequireAllStagesPassing() && this.getBlockingStrategy() == that.getBlockingStrategy();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isEnabledForBranches(), this.isRequireAllStagesPassing(), this.getBlockingStrategy()});
    }

    @Override
    public void validate() {
        ValidationContext context = ValidationContext.of("Dependencies configuration");
        ImporterUtils.checkRequired(context.with("blockingStrategy"), (Object)this.blockingStrategy);
    }
}

