/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.task;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TaskProperties
implements EntityProperties {
    private final String description;
    private final boolean enabled;

    protected TaskProperties() {
        this.description = "";
        this.enabled = true;
    }

    public TaskProperties(String description, boolean enabled) throws PropertiesValidationException {
        this.description = description;
        this.enabled = enabled;
    }

    @NotNull
    public abstract AtlassianModuleProperties getAtlassianPlugin();

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskProperties that = (TaskProperties)o;
        return this.isEnabled() == that.isEnabled() && Objects.equals(this.getAtlassianPlugin(), that.getAtlassianPlugin()) && Objects.equals(this.getDescription(), that.getDescription());
    }

    public int hashCode() {
        return Objects.hash(this.getAtlassianPlugin(), this.getDescription(), this.isEnabled());
    }

    @Override
    public void validate() {
    }

    public String toString() {
        return "TaskProperties{description='" + this.description + '\'' + ", enabled=" + this.enabled + '}';
    }
}

