/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.trigger;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TriggerProperties
implements EntityProperties {
    private final String name;
    private final String description;
    private final boolean enabled;

    protected TriggerProperties() {
        this.name = null;
        this.description = null;
        this.enabled = true;
    }

    public TriggerProperties(String name, String description, boolean enabled) {
        this.name = name;
        this.description = description;
        this.enabled = enabled;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public abstract AtlassianModuleProperties getAtlassianPlugin();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerProperties that = (TriggerProperties)o;
        return this.enabled == that.enabled && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.enabled);
    }

    @Override
    public void validate() throws PropertiesValidationException {
        ImporterUtils.checkNotBlank("name", this.name);
    }

    public String toString() {
        return "TriggerProperties{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", enabled=" + this.enabled + '}';
    }
}

