/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.util;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;

public final class EntityPropertiesBuilders {
    private EntityPropertiesBuilders() {
    }

    @NotNull
    public static <T extends EntityProperties, B extends EntityPropertiesBuilder<T>> T build(@NotNull B builder) {
        try {
            Method buildMethod = builder.getClass().getDeclaredMethod("build", new Class[0]);
            buildMethod.setAccessible(true);
            return (T)((EntityProperties)buildMethod.invoke(builder, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException(EntityPropertiesBuilders.getErrorMessage(builder), e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof PropertiesValidationException) {
                throw (PropertiesValidationException)e.getCause();
            }
            throw new IllegalStateException(EntityPropertiesBuilders.getErrorMessage(builder), e);
        }
    }

    @NotNull
    private static String getErrorMessage(@NotNull Object builder) {
        return "Cannot invoke builder on class " + builder.getClass().getName();
    }
}

