/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.validators.common;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImporterUtils {
    private ImporterUtils() {
    }

    public static void checkPluginKey(@NotNull ValidationContext validationContext, @NotNull AtlassianModuleProperties actual, @NotNull AtlassianModuleProperties expected) throws PropertiesValidationException {
        if (!expected.equals(actual)) {
            throw new PropertiesValidationException(Collections.singletonList(new ValidationProblem(validationContext, "Invalid plugin key, got '%s', expected '%s'", actual.getCompleteModuleKey(), expected.getCompleteModuleKey())));
        }
    }

    public static void checkThat(@NotNull ValidationContext validationContext, boolean condition, @NotNull String messageFormat, Object ... messageArgs) throws PropertiesValidationException {
        if (!condition) {
            throw new PropertiesValidationException(Collections.singletonList(new ValidationProblem(validationContext, messageFormat, messageArgs)));
        }
    }

    public static void checkNoErrors(@NotNull List<ValidationProblem> errors) throws PropertiesValidationException {
        if (!errors.isEmpty()) {
            throw new PropertiesValidationException(errors);
        }
    }

    public static void checkRequired(@NotNull ValidationContext validationContext, @Nullable Object o) throws PropertiesValidationException {
        if (o == null) {
            throw new PropertiesValidationException(Collections.singletonList(new ValidationProblem(validationContext, "Property is required.")));
        }
    }

    public static void checkRequiredNotBlank(@NotNull ValidationContext validationContext, @Nullable String s) throws PropertiesValidationException {
        if (s == null || StringUtils.isBlank((CharSequence)s)) {
            throw new PropertiesValidationException(Collections.singletonList(new ValidationProblem(validationContext, "Property must not be blank.")));
        }
    }

    public static <T> T checkNotNull(@NotNull String argumentName, @Nullable T o) throws PropertiesValidationException {
        if (o == null) {
            throw new PropertiesValidationException("Argument " + argumentName + " can not be null.");
        }
        return o;
    }

    public static String checkNotEmpty(@NotNull String argumentName, @Nullable String s) throws PropertiesValidationException {
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new PropertiesValidationException("Argument " + argumentName + " can not be empty.");
        }
        return s;
    }

    public static void checkArgument(@NotNull ValidationContext validationContext, boolean expression, Object errorMessage) {
        if (!expression) {
            throw new PropertiesValidationException(Collections.singletonList(new ValidationProblem(validationContext, String.valueOf(errorMessage))));
        }
    }

    public static String checkNotBlank(@NotNull String argumentName, @Nullable String o) throws PropertiesValidationException {
        ImporterUtils.checkNotNull(argumentName, o);
        if (StringUtils.isBlank((CharSequence)o)) {
            throw new PropertiesValidationException("Argument " + argumentName + " can not be blank.");
        }
        return o;
    }

    public static void checkNotNegative(@NotNull String argumentName, int value) throws PropertiesValidationException {
        if (value < 0) {
            throw new PropertiesValidationException("Argument " + argumentName + " can not be a negative number.");
        }
    }

    public static void checkNotNegative(@NotNull ValidationContext validationContext, int value) throws PropertiesValidationException {
        if (value < 0) {
            throw new PropertiesValidationException(Collections.singletonList(new ValidationProblem(validationContext, "Property can not be a negative number.")));
        }
    }

    public static void checkPositive(@NotNull String argumentName, int value) throws PropertiesValidationException {
        if (value <= 0) {
            throw new PropertiesValidationException("Argument " + argumentName + " must be a positive number.");
        }
    }

    public static void checkPositive(@NotNull ValidationContext validationContext, int value) throws PropertiesValidationException {
        if (value <= 0) {
            throw new PropertiesValidationException(Collections.singletonList(new ValidationProblem(validationContext, "Property must be a positive number.")));
        }
    }
}

