/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover.internal.instrumentation;

import com.atlassian.maven.plugin.clover.internal.CompilerConfiguration;
import com.atlassian.maven.plugin.clover.internal.instrumentation.AbstractInstrumenter;
import com.atlassian.maven.plugin.clover.internal.scanner.CloverSourceScanner;
import com.atlassian.maven.plugin.clover.internal.scanner.MainSourceScanner;
import java.io.File;
import java.util.List;

public class MainInstrumenter
extends AbstractInstrumenter {
    private final MainSourceScanner scanner;

    public MainInstrumenter(CompilerConfiguration configuration, String outputSourceDirectory) {
        super(configuration, outputSourceDirectory);
        this.scanner = new MainSourceScanner(configuration, outputSourceDirectory);
    }

    @Override
    protected CloverSourceScanner getSourceScanner() {
        return this.scanner;
    }

    @Override
    protected String getSourceDirectory() {
        return this.getConfiguration().getProject().getBuild().getSourceDirectory();
    }

    @Override
    protected void setSourceDirectory(String targetDirectory) {
        this.getConfiguration().getProject().getBuild().setSourceDirectory(targetDirectory);
    }

    @Override
    protected List<String> getCompileSourceRoots() {
        return this.getConfiguration().getProject().getCompileSourceRoots();
    }

    @Override
    protected void addCompileSourceRoot(String sourceRoot) {
        this.getConfiguration().getProject().addCompileSourceRoot(sourceRoot);
    }

    @Override
    protected boolean isGeneratedSourcesDirectory(String sourceRoot) {
        String generatedSrcDirDefaultLifecycle = File.separator + "target" + File.separator + "generated-sources";
        String generatedSrcDirCloverLifecycle = File.separator + "target" + File.separator + "clover" + File.separator + "generated-sources";
        return sourceRoot.indexOf(generatedSrcDirDefaultLifecycle) != -1 || sourceRoot.indexOf(generatedSrcDirCloverLifecycle) != -1;
    }

    @Override
    protected String getSourceType() {
        return "main";
    }
}

