/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import com.cenqua.clover.cfg.Percentage;
import com.cenqua.clover.tasks.CloverPassTask;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class CloverCheckMojo
extends AbstractCloverMojo {
    String targetPercentage;
    String contextFilters;
    boolean failOnViolation;
    File historyDir;
    String historyThreshold;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping clover check.");
            return;
        }
        if (!this.isInCloverForkedLifecycle()) {
            if (this.areCloverDatabasesAvailable()) {
                super.execute();
                AbstractCloverMojo.waitForFlush(this.getWaitForFlush(), this.getFlushInterval());
                this.check();
            } else {
                this.getLog().info((CharSequence)"No Clover database found, skipping test coverage verification");
            }
        }
    }

    private void check() throws MojoExecutionException {
        if (new File(this.resolveCloverDatabase()).exists()) {
            this.checkDatabase(this.resolveCloverDatabase());
        }
        if (new File(this.getCloverMergeDatabase()).exists()) {
            this.checkDatabase(this.getCloverMergeDatabase());
        }
    }

    private void checkDatabase(String database) throws MojoExecutionException {
        Project antProject = new Project();
        antProject.init();
        AbstractCloverMojo.registerCloverAntTasks(antProject, this.getLog());
        CloverPassTask cloverPassTask = this.createCloverPassTask(database, antProject);
        cloverPassTask.init();
        cloverPassTask.setInitString(database);
        cloverPassTask.setHaltOnFailure(true);
        cloverPassTask.setFailureProperty("clovercheckproperty");
        if (this.targetPercentage != null) {
            cloverPassTask.setTarget(new Percentage(this.targetPercentage));
            this.getLog().info((CharSequence)("Checking for coverage of [" + this.targetPercentage + "] for database [" + database + "]"));
        } else if (this.historyDir.exists() && this.historyDir.isDirectory()) {
            cloverPassTask.setHistorydir(this.historyDir);
            cloverPassTask.setThreshold(new Percentage(this.historyThreshold));
            this.getLog().info((CharSequence)("Checking coverage against historical data [" + this.historyDir + " +/-" + this.historyThreshold + " ] for database [" + database + "]"));
        } else {
            this.getLog().warn((CharSequence)("Skipping clover2:check as 'maven.clover.targetPercentage' is not defined and 'maven.clover.historyDir' (" + this.historyDir.getPath() + ") does not exist or is not a directory."));
            return;
        }
        if (this.contextFilters != null) {
            cloverPassTask.setFilter(this.contextFilters);
        }
        try {
            cloverPassTask.execute();
        }
        catch (BuildException e) {
            this.getLog().error((CharSequence)antProject.getProperty("clovercheckproperty"));
            if (this.failOnViolation) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            this.getLog().warn((CharSequence)"Clover test percentage coverage is below threshold but failOnViolation is set to  false, preventing the build from failing.");
        }
    }

    CloverPassTask createCloverPassTask(String database, Project antProject) {
        return (CloverPassTask)antProject.createTask("clover-check");
    }

    private boolean isInCloverForkedLifecycle() {
        return this.getProject().getBuild().getDirectory().endsWith("clover");
    }
}

