/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.maven.plugin.clover.MvnLogBuildListener;
import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import com.atlassian.maven.plugin.clover.internal.ConfigUtil;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Delete;

public class CloverCleanMojo
extends AbstractCloverMojo {
    protected boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        Project project = new Project();
        project.setBasedir(this.getProject().getBasedir().getPath());
        project.addBuildListener((BuildListener)new MvnLogBuildListener(this.getLog()));
        project.init();
        File snapshotFile = new ConfigUtil(this).resolveSnapshotFile(this.snapshot);
        this.removeFile(snapshotFile, project);
    }

    private void removeFile(File snapshot, Project project) throws MojoExecutionException {
        if (!snapshot.exists() || snapshot.isDirectory()) {
            return;
        }
        Delete delete = new Delete();
        delete.setProject(project);
        delete.setIncludeEmptyDirs(true);
        delete.init();
        delete.setFile(snapshot);
        delete.execute();
        if (snapshot.exists()) {
            this.getLog().warn((CharSequence)("clover2:clean could not delete file: " + snapshot));
        }
    }
}

