/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.maven.plugin.clover.DistributedCoverage;
import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import com.atlassian.maven.plugin.clover.internal.CompilerConfiguration;
import com.atlassian.maven.plugin.clover.internal.instrumentation.MainInstrumenter;
import com.atlassian.maven.plugin.clover.internal.instrumentation.TestInstrumenter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;

public class CloverInstrumentInternalMojo
extends AbstractCloverMojo
implements CompilerConfiguration {
    private String cloverOutputDirectory;
    private List pluginArtifacts;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private ArtifactRepository localRepository;
    private Set includes = new HashSet<String>(Arrays.asList("**/*.java"));
    private Set excludes = new HashSet();
    private Map methodContexts = new HashMap();
    private Map statementContexts = new HashMap();
    private boolean includesAllSourceRoots;
    private boolean includesTestSourceRoots;
    private boolean useFullyQualifiedJavaLang;
    private boolean useCloverClassifier = true;
    private String encoding;
    private int staleMillis;
    private DistributedCoverage distributedCoverage;
    private String instrumentation;
    private long cloveredArtifactExpiryInMillis;
    private static Map originalSrcMap = new HashMap();
    private static Map originalSrcTestMap = new HashMap();

    public static String getOriginalSrcDir(String module) {
        return (String)originalSrcMap.get(module);
    }

    public static String getOriginalSrcTestDir(String module) {
        return (String)originalSrcTestMap.get(module);
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping clover instrumentation.");
            return;
        }
        CloverInstrumentInternalMojo.resetSrcDirsOriginal(this.getProject().getArtifact(), this);
        new File(this.cloverOutputDirectory).mkdirs();
        String cloverOutputSourceDirectory = new File(this.cloverOutputDirectory, this.getSrcName()).getPath();
        String cloverOutputTestSourceDirectory = new File(this.cloverOutputDirectory, this.getSrcTestName()).getPath();
        new File(this.resolveCloverDatabase()).getParentFile().mkdirs();
        super.execute();
        this.logArtifacts("before changes");
        MainInstrumenter mainInstrumenter = new MainInstrumenter(this, cloverOutputSourceDirectory);
        TestInstrumenter testInstrumenter = new TestInstrumenter(this, cloverOutputTestSourceDirectory);
        if (this.isJavaProject()) {
            mainInstrumenter.instrument();
            if (this.includesTestSourceRoots) {
                testInstrumenter.instrument();
            }
        }
        this.addCloverDependencyToCompileClasspath();
        this.swizzleCloverDependencies();
        String originalSrcDir = mainInstrumenter.redirectSourceDirectories();
        originalSrcMap.put(this.getProject().getArtifactId(), originalSrcDir);
        if (this.includesTestSourceRoots) {
            String originalSrcTestDir = testInstrumenter.redirectSourceDirectories();
            originalSrcTestMap.put(this.getProject().getArtifactId(), originalSrcTestDir);
        }
        this.redirectOutputDirectories();
        this.redirectArtifact();
        this.logArtifacts("after changes");
    }

    public static void resetSrcDirsOriginal(Artifact artifact, CompilerConfiguration config) {
        if (originalSrcMap.containsKey(artifact)) {
            String sourceDirectory = (String)originalSrcMap.get(artifact);
            MainInstrumenter mainInstrumenter = new MainInstrumenter(config, sourceDirectory);
            mainInstrumenter.redirectSourceDirectories();
        }
        if (originalSrcTestMap.containsKey(artifact)) {
            String testDirectory = (String)originalSrcTestMap.get(artifact);
            TestInstrumenter instrumenter = new TestInstrumenter(config, testDirectory);
            instrumenter.redirectSourceDirectories();
        }
    }

    protected String getSrcTestName() {
        return "src-test";
    }

    protected String getSrcName() {
        return "src";
    }

    private boolean isJavaProject() {
        ArtifactHandler artifactHandler = this.getProject().getArtifact().getArtifactHandler();
        if (!"java".equals(artifactHandler.getLanguage())) {
            this.getLog().warn((CharSequence)("The reported language of this project is " + artifactHandler.getLanguage() + ", attempting to instrument sources anyway."));
        }
        return true;
    }

    protected void redirectOutputDirectories() {
        this.getProject().getBuild().setDirectory(this.cloverOutputDirectory);
        this.getProject().getBuild().setOutputDirectory(new File(this.cloverOutputDirectory, "classes").getPath());
        this.getProject().getBuild().setTestOutputDirectory(new File(this.cloverOutputDirectory, "test-classes").getPath());
        new File(this.getProject().getBuild().getOutputDirectory()).mkdirs();
        new File(this.getProject().getBuild().getTestOutputDirectory()).mkdirs();
    }

    protected void redirectArtifact() {
        if (!this.getProject().getPackaging().equals("pom")) {
            Artifact oldArtifact = this.getProject().getArtifact();
            Artifact newArtifact = this.artifactFactory.createArtifactWithClassifier(oldArtifact.getGroupId(), oldArtifact.getArtifactId(), oldArtifact.getVersion(), oldArtifact.getType(), "clover");
            this.getProject().setArtifact(newArtifact);
            String finalName = this.getProject().getBuild().getFinalName() == null ? this.getProject().getArtifactId() + "-" + this.getProject().getVersion() : this.getProject().getBuild().getFinalName();
            this.getProject().getBuild().setFinalName(finalName + (this.useCloverClassifier ? "-clover" : ""));
        }
    }

    private void swizzleCloverDependencies() {
        Set swizzledDependencyArtifacts = this.swizzleCloverDependencies(this.getProject().getDependencyArtifacts());
        Set artifacts = this.getProject().getArtifacts();
        Set dependencyArtifacts = this.getProject().getDependencyArtifacts();
        artifacts.removeAll(dependencyArtifacts);
        Set swizzledArtifacts = this.swizzleCloverDependencies(artifacts);
        swizzledArtifacts.addAll(swizzledDependencyArtifacts);
        this.getProject().setDependencyArtifacts(swizzledDependencyArtifacts);
        this.getProject().setArtifacts(swizzledArtifacts);
    }

    protected Set swizzleCloverDependencies(Set artifacts) {
        LinkedHashSet<Artifact> resolvedArtifacts = new LinkedHashSet<Artifact>();
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            if (artifact.getClassifier() == null) {
                Artifact cloveredArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), "clover");
                try {
                    this.artifactResolver.resolve(cloveredArtifact, new ArrayList(), this.localRepository);
                    cloveredArtifact.setScope(artifact.getScope());
                    if (cloveredArtifact.getFile().lastModified() + this.cloveredArtifactExpiryInMillis < artifact.getFile().lastModified()) {
                        this.getLog().warn((CharSequence)("Using [" + artifact.getId() + "], built on " + new Date(artifact.getFile().lastModified()) + " even though a Clovered version exists " + "but it's older (lastModified: " + new Date(cloveredArtifact.getFile().lastModified()) + " ) and could fail the build. Please consider running Clover again on that " + "dependency's project."));
                        resolvedArtifacts.add(artifact);
                        continue;
                    }
                    resolvedArtifacts.add(cloveredArtifact);
                }
                catch (ArtifactResolutionException e) {
                    this.getLog().warn((CharSequence)("Skipped dependency [" + artifact.getId() + "] due to resolution error: " + e.getMessage()));
                    resolvedArtifacts.add(artifact);
                }
                catch (ArtifactNotFoundException e) {
                    this.getLog().debug((CharSequence)("Skipped dependency [" + artifact.getId() + "] as the clovered artifact could not be found"));
                    resolvedArtifacts.add(artifact);
                }
                continue;
            }
            this.getLog().debug((CharSequence)("Skipped dependency [" + artifact.getId() + "] as it has a classifier"));
            resolvedArtifacts.add(artifact);
        }
        return resolvedArtifacts;
    }

    protected Artifact findCloverArtifact(List pluginArtifacts) {
        Artifact cloverArtifact = null;
        Iterator artifacts = pluginArtifacts.iterator();
        while (artifacts.hasNext() && cloverArtifact == null) {
            Artifact artifact = (Artifact)artifacts.next();
            if (!"com.cenqua.clover".equals(artifact.getGroupId()) || !"clover".equals(artifact.getArtifactId())) continue;
            cloverArtifact = artifact;
        }
        return cloverArtifact;
    }

    private void addCloverDependencyToCompileClasspath() throws MojoExecutionException {
        Artifact cloverArtifact = this.findCloverArtifact(this.pluginArtifacts);
        if (cloverArtifact == null) {
            throw new MojoExecutionException("Couldn't find [com.cenqua.clover:clover] artifact in plugin dependencies");
        }
        cloverArtifact = this.artifactFactory.createArtifact(cloverArtifact.getGroupId(), cloverArtifact.getArtifactId(), cloverArtifact.getVersion(), "compile", cloverArtifact.getType());
        LinkedHashSet<Artifact> set = new LinkedHashSet<Artifact>(this.getProject().getDependencyArtifacts());
        set.add(cloverArtifact);
        this.getProject().setDependencyArtifacts(set);
    }

    private void logArtifacts(String message) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("[Clover] List of dependency artifacts " + message + ":"));
            this.logArtifacts(this.getProject().getDependencyArtifacts());
            this.getLog().debug((CharSequence)("[Clover] List of artifacts " + message + ":"));
            this.logArtifacts(this.getProject().getArtifacts());
        }
    }

    private void logArtifacts(Set artifacts) {
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            this.getLog().debug((CharSequence)("[Clover]   Artifact [" + artifact.getId() + "], scope = [" + artifact.getScope() + "]"));
        }
    }

    protected void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    protected void setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    public Set getIncludes() {
        return this.includes;
    }

    public Set getExcludes() {
        return this.excludes;
    }

    public boolean includesAllSourceRoots() {
        return this.includesAllSourceRoots;
    }

    public boolean isUseFullyQualifiedJavaLang() {
        return this.useFullyQualifiedJavaLang;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Map getMethodContexts() {
        return this.methodContexts;
    }

    public Map getStatementContexts() {
        return this.statementContexts;
    }

    public int getStaleMillis() {
        return this.staleMillis;
    }

    public String getInstrumentation() {
        return this.instrumentation;
    }

    public DistributedCoverage getDistributedCoverage() {
        return this.distributedCoverage;
    }
}

