/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.maven.plugin.clover.MvnLogBuildListener;
import com.atlassian.maven.plugin.clover.MvnLogger;
import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import com.atlassian.maven.plugin.clover.internal.ConfigUtil;
import com.cenqua.clover.Logger;
import com.cenqua.clover.types.CloverAlwaysRunTestSet;
import com.cenqua.clover.types.CloverOptimizedTestSet;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class CloverOptimizerMojo
extends AbstractCloverMojo {
    private int fullRunEvery;
    private List optimizeIncludes;
    private List optimizeExcludes;
    private List alwaysRunTests;
    private String ordering;
    private boolean enabled;
    private boolean minimize;
    private static final List DEFAULT_INCLUDES = Arrays.asList("**/Test*.java", "**/*Test.java", "**/*TestCase.java");

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping build optimization.");
            return;
        }
        String sourceDirectory = this.getProject().getBuild().getSourceDirectory();
        String testSourceDirectory = this.getProject().getBuild().getTestSourceDirectory();
        if (!new File(sourceDirectory).exists() && !new File(testSourceDirectory).exists()) {
            this.getLog().info((CharSequence)(sourceDirectory + " and " + testSourceDirectory + " do not exist. No optimization will be done for: " + this.getProject().getArtifactId()));
            return;
        }
        Project antProj = new Project();
        antProj.init();
        antProj.addBuildListener((BuildListener)new MvnLogBuildListener(this.getLog()));
        List optimizedTests = this.configureOptimisedTestSet(antProj);
        StringBuffer testPattern = new StringBuffer();
        Iterator iterator = optimizedTests.iterator();
        while (iterator.hasNext()) {
            Resource test = (Resource)iterator.next();
            this.getLog().debug((CharSequence)("Running TEST: " + test.getName()));
            testPattern.append(test.getName());
            testPattern.append(",");
        }
        this.getLog().debug((CharSequence)("Setting test property to: '" + testPattern + "'"));
        if (optimizedTests.size() == 0) {
            this.getProject().getProperties().put("failIfNoTests", "false");
        }
        this.getProject().getProperties().put("test", testPattern.toString());
    }

    private List configureOptimisedTestSet(Project antProj) {
        Xpp3Dom config;
        List surefireIncludes = null;
        List surefireExcludes = null;
        Plugin surefirePlugin = this.lookupSurefirePlugin();
        if (surefirePlugin != null && (config = (Xpp3Dom)surefirePlugin.getConfiguration()) != null) {
            surefireIncludes = this.extractNestedStrings("includes", config);
            surefireExcludes = this.extractNestedStrings("excludes", config);
        }
        List includes = this.optimizeIncludes != null ? this.optimizeIncludes : (surefireIncludes != null ? surefireIncludes : DEFAULT_INCLUDES);
        List excludes = this.optimizeExcludes != null ? this.optimizeExcludes : surefireExcludes;
        CloverOptimizedTestSet testsToRun = new CloverOptimizedTestSet();
        testsToRun.setProject(antProj);
        testsToRun.setLogger((Logger)new MvnLogger(this.getLog()));
        testsToRun.setFullRunEvery(this.fullRunEvery);
        testsToRun.setDebug(this.debug);
        testsToRun.setSnapshotFile(new ConfigUtil(this).resolveSnapshotFile(this.snapshot));
        if (this.ordering != null) {
            CloverOptimizedTestSet.TestOrdering order = new CloverOptimizedTestSet.TestOrdering();
            order.setValue(this.ordering);
            testsToRun.setOrdering(order);
        }
        testsToRun.setMinimize(this.minimize);
        testsToRun.setEnabled(this.enabled);
        antProj.setProperty("clover.initstring", this.resolveCloverDatabase());
        antProj.setName(this.getProject().getName());
        List testSources = this.getProject().getTestCompileSourceRoots();
        Iterator iterator = testSources.iterator();
        while (iterator.hasNext()) {
            String testRoot = (String)iterator.next();
            File testRootDir = new File(testRoot);
            if (!testRootDir.exists()) continue;
            FileSet testFileSet = new FileSet();
            testFileSet.setProject(antProj);
            testFileSet.setDir(testRootDir);
            testFileSet.appendIncludes(includes.toArray(new String[includes.size()]));
            this.getLog().debug((CharSequence)("Appending includes: " + includes));
            if (excludes != null && excludes.size() > 0) {
                testFileSet.appendExcludes(excludes.toArray(new String[excludes.size()]));
                this.getLog().debug((CharSequence)("Appending excludes: " + excludes));
            }
            testsToRun.add((ResourceCollection)testFileSet);
            if (this.alwaysRunTests == null) continue;
            FileSet alwaysRunFileSet = new FileSet();
            alwaysRunFileSet.setProject(antProj);
            alwaysRunFileSet.setDir(testRootDir);
            alwaysRunFileSet.appendIncludes(this.alwaysRunTests.toArray(new String[this.alwaysRunTests.size()]));
            CloverAlwaysRunTestSet alwaysRunTestSet = new CloverAlwaysRunTestSet();
            alwaysRunTestSet.setProject(antProj);
            alwaysRunTestSet.add((ResourceCollection)alwaysRunFileSet);
            testsToRun.add(alwaysRunTestSet);
        }
        return testsToRun.getOptimizedTestResource();
    }

    private List extractNestedStrings(String childname, Xpp3Dom config) {
        Xpp3Dom subelement = config.getChild(childname);
        if (subelement != null) {
            LinkedList<String> result = new LinkedList<String>();
            Xpp3Dom[] children = subelement.getChildren();
            for (int i = 0; i < children.length; ++i) {
                Xpp3Dom child = children[i];
                result.add(child.getValue());
            }
            this.getLog().info((CharSequence)("Extracted strings: " + result));
            return result;
        }
        return null;
    }

    private Plugin lookupSurefirePlugin() {
        String key = "org.apache.maven.plugins:maven-surefire-plugin";
        MavenProject mavenProject = this.getProject();
        if (mavenProject == null) {
            this.getLog().warn((CharSequence)"Maven execution project is null. Surefire configuration will be ignored.");
            return null;
        }
        List plugins = mavenProject.getBuildPlugins();
        Iterator iterator = plugins.iterator();
        while (iterator.hasNext()) {
            Plugin plugin = (Plugin)iterator.next();
            if (!"org.apache.maven.plugins:maven-surefire-plugin".equalsIgnoreCase(plugin.getKey())) continue;
            return plugin;
        }
        return null;
    }
}

