/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover.internal.instrumentation;

import com.atlassian.maven.plugin.clover.MvnLogger;
import com.atlassian.maven.plugin.clover.internal.CompilerConfiguration;
import com.atlassian.maven.plugin.clover.internal.scanner.CloverSourceScanner;
import com.cenqua.clover.CloverInstr;
import com.cenqua.clover.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractInstrumenter {
    private CompilerConfiguration configuration;
    String outputSourceDirectory;
    private static final String PROP_PROJECT_BUILD_SOURCEENCODING = "project.build.sourceEncoding";

    public AbstractInstrumenter(CompilerConfiguration configuration, String outputSourceDirectory) {
        this.configuration = configuration;
        this.outputSourceDirectory = outputSourceDirectory;
    }

    protected CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void instrument() throws MojoExecutionException {
        CloverSourceScanner scanner = this.getSourceScanner();
        Map filesToInstrument = scanner.getSourceFilesToInstrument();
        if (filesToInstrument.isEmpty()) {
            this.getConfiguration().getLog().info((CharSequence)("No Clover instrumentation done on source files in: " + this.getCompileSourceRoots() + " as no matching sources files found"));
        } else {
            this.instrumentSources(filesToInstrument, this.outputSourceDirectory);
        }
        if (this.configuration.copyExcludedFiles()) {
            this.copyExcludedFiles(scanner.getExcludedFiles(), this.outputSourceDirectory);
        }
    }

    public String redirectSourceDirectories() {
        return this.redirectSourceDirectories(this.outputSourceDirectory);
    }

    protected abstract CloverSourceScanner getSourceScanner();

    protected abstract String getSourceDirectory();

    protected abstract void setSourceDirectory(String var1);

    protected abstract List getCompileSourceRoots();

    protected abstract void addCompileSourceRoot(String var1);

    private String redirectSourceDirectories(String targetDirectory) {
        String oldSourceDirectory = this.getSourceDirectory();
        if (new File(oldSourceDirectory).exists()) {
            this.setSourceDirectory(targetDirectory);
        }
        this.getConfiguration().getLog().debug((CharSequence)"Clover source directories before change:");
        this.logSourceDirectories();
        ArrayList sourceRoots = new ArrayList(this.getCompileSourceRoots());
        this.getCompileSourceRoots().removeAll(sourceRoots);
        Iterator i = sourceRoots.iterator();
        while (i.hasNext()) {
            String sourceRoot = (String)i.next();
            if (new File(oldSourceDirectory).exists() && sourceRoot.equals(oldSourceDirectory)) {
                this.addCompileSourceRoot(this.getSourceDirectory());
                continue;
            }
            if (this.isGeneratedSourcesDirectory(sourceRoot) || this.getConfiguration().includesAllSourceRoots()) continue;
            this.addCompileSourceRoot(sourceRoot);
        }
        this.getConfiguration().getLog().debug((CharSequence)"Clover main source directories after change:");
        this.logSourceDirectories();
        return oldSourceDirectory;
    }

    private boolean isGeneratedSourcesDirectory(String sourceRoot) {
        String generatedSourcesDirectoryName = File.separator + "target" + File.separator + "generated-sources";
        return sourceRoot.indexOf(generatedSourcesDirectoryName) != -1;
    }

    private void logSourceDirectories() {
        if (this.getConfiguration().getLog().isDebugEnabled()) {
            Iterator i = this.getCompileSourceRoots().iterator();
            while (i.hasNext()) {
                String sourceRoot = (String)i.next();
                this.getConfiguration().getLog().debug((CharSequence)("[Clover]  source root [" + sourceRoot + "]"));
            }
        }
    }

    private void copyExcludedFiles(Map excludedFiles, String targetDirectory) throws MojoExecutionException {
        Iterator sourceRoots = excludedFiles.keySet().iterator();
        while (sourceRoots.hasNext()) {
            String sourceRoot = (String)sourceRoots.next();
            String[] filesInSourceRoot = (String[])excludedFiles.get(sourceRoot);
            for (int i = 0; i < filesInSourceRoot.length; ++i) {
                File srcFile = new File(sourceRoot, filesInSourceRoot[i]);
                try {
                    this.configuration.getLog().debug((CharSequence)("Copying excluded file: " + srcFile.getAbsolutePath() + " to " + targetDirectory));
                    FileUtils.copyFile((File)srcFile, (File)new File(targetDirectory, srcFile.getPath().substring(sourceRoot.length())));
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to copy excluded file [" + srcFile + "] to [" + targetDirectory + "]", (Exception)e);
                }
            }
        }
    }

    private void instrumentSources(Map filesToInstrument, String outputDir) throws MojoExecutionException {
        Logger.setInstance((Logger)new MvnLogger(this.configuration.getLog()));
        new File(outputDir).mkdirs();
        int result = CloverInstr.mainImpl((String[])this.createCliArgs(filesToInstrument, outputDir));
        if (result != 0) {
            throw new MojoExecutionException("Clover has failed to instrument the source files in the [" + outputDir + "] directory");
        }
    }

    private String[] createCliArgs(Map filesToInstrument, String outputDir) throws MojoExecutionException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add("-p");
        parameters.add(this.getConfiguration().getFlushPolicy());
        parameters.add("-f");
        parameters.add("" + this.getConfiguration().getFlushInterval());
        parameters.add("-i");
        parameters.add(this.getConfiguration().resolveCloverDatabase());
        parameters.add("-d");
        parameters.add(outputDir);
        if (this.getConfiguration().getLog().isDebugEnabled()) {
            parameters.add("-v");
        }
        if (this.getConfiguration().getDistributedCoverage() != null && this.getConfiguration().getDistributedCoverage().isEnabled()) {
            parameters.add("--distributedCoverage");
            parameters.add(this.getConfiguration().getDistributedCoverage().toString());
        }
        if (this.getConfiguration().getJdk() != null) {
            if (this.getConfiguration().getJdk().equals("1.4")) {
                parameters.add("--source");
                parameters.add("1.4");
            } else if (this.getConfiguration().getJdk().equals("1.5")) {
                parameters.add("--source");
                parameters.add("1.5");
            } else if (this.getConfiguration().getJdk().equals("1.6")) {
                parameters.add("--source");
                parameters.add("1.6");
            } else if (this.getConfiguration().getJdk().equals("1.7")) {
                parameters.add("--source");
                parameters.add("1.7");
            } else {
                throw new MojoExecutionException("Unsupported jdk version [" + this.getConfiguration().getJdk() + "]. Valid values are [1.4], [1.5], [1.6] and [1.7]");
            }
        }
        if (!this.getConfiguration().isUseFullyQualifiedJavaLang()) {
            parameters.add("--dontFullyQualifyJavaLang");
        }
        if (this.getConfiguration().getEncoding() != null) {
            parameters.add("--encoding");
            parameters.add(this.getConfiguration().getEncoding());
        } else if (this.getConfiguration().getProject().getProperties().get(PROP_PROJECT_BUILD_SOURCEENCODING) != null) {
            parameters.add("--encoding");
            parameters.add(this.getConfiguration().getProject().getProperties().get(PROP_PROJECT_BUILD_SOURCEENCODING));
        }
        if (this.getConfiguration().getInstrumentation() != null) {
            parameters.add("--instrlevel");
            parameters.add(this.getConfiguration().getInstrumentation());
        }
        Iterator sourceRoots = filesToInstrument.keySet().iterator();
        while (sourceRoots.hasNext()) {
            String srcDir = (String)sourceRoots.next();
            String[] filesInSourceRoot = (String[])filesToInstrument.get(srcDir);
            for (int i = 0; i < filesInSourceRoot.length; ++i) {
                String s = filesInSourceRoot[i];
                File file = new File(srcDir, s);
                parameters.add(file.getPath());
            }
        }
        this.addCustomContexts(parameters, this.getConfiguration().getMethodContexts().entrySet(), "-mc");
        this.addCustomContexts(parameters, this.getConfiguration().getStatementContexts().entrySet(), "-sc");
        if (this.getConfiguration().getLog().isDebugEnabled()) {
            this.getConfiguration().getLog().debug((CharSequence)"Parameter list being passed to Clover CLI:");
            Iterator it = parameters.iterator();
            while (it.hasNext()) {
                String param = (String)it.next();
                this.getConfiguration().getLog().debug((CharSequence)("  parameter = [" + param + "]"));
            }
        }
        return parameters.toArray(new String[0]);
    }

    private void addCustomContexts(List parameters, Set contexts, String flag) {
        Iterator iterator = contexts.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            parameters.add(flag);
            parameters.add(entry.getKey() + "=" + entry.getValue());
        }
    }
}

