/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.clover.types.CloverAlwaysRunTestSet;
import com.atlassian.clover.types.CloverOptimizedTestSet;
import com.atlassian.clover.util.FileUtils;
import com.atlassian.maven.plugin.clover.MvnLogBuildListener;
import com.atlassian.maven.plugin.clover.MvnLogger;
import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import com.atlassian.maven.plugin.clover.internal.ConfigUtil;
import com.cenqua.clover.Logger;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloverOptimizerMojo
extends AbstractCloverMojo {
    private int fullRunEvery;
    private List<String> optimizeIncludes;
    private List<String> optimizeExcludes;
    private List<String> alwaysRunTests;
    private String ordering;
    private boolean enabled;
    private boolean minimize;
    private static final List<String> DEFAULT_INCLUDES = Arrays.asList("**/Test*.java", "**/*Test.java", "**/*TestCase.java");
    private static final String REGEX_START = "%regex[";
    private static final String REGEX_END = "]";

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping build optimization.");
            return;
        }
        String sourceDirectory = this.getProject().getBuild().getSourceDirectory();
        String testSourceDirectory = this.getProject().getBuild().getTestSourceDirectory();
        if (!new File(sourceDirectory).exists() && !new File(testSourceDirectory).exists()) {
            this.getLog().info((CharSequence)new StringBuffer().append(sourceDirectory).append(" and ").append(testSourceDirectory).append(" do not exist. No optimization will be done for: ").append(this.getProject().getGroupId()).append(":").append(this.getProject().getArtifactId()).toString());
            return;
        }
        Project antProj = new Project();
        antProj.init();
        antProj.addBuildListener((BuildListener)new MvnLogBuildListener(this.getLog()));
        List<Resource> optimizedTests = this.configureOptimisedTestSet(antProj);
        StringBuffer testPattern = new StringBuffer();
        for (Resource test : optimizedTests) {
            this.getLog().debug((CharSequence)new StringBuffer().append("Running TEST: ").append(test.getName()).toString());
            testPattern.append(test.getName());
            testPattern.append(",");
        }
        this.getLog().debug((CharSequence)new StringBuffer().append("Setting test property to: '").append((Object)testPattern).append("'").toString());
        this.getProject().getProperties().put("failIfNoTests", "false");
        if (optimizedTests.size() == 0) {
            this.getProject().getProperties().put("test", "clover/optimized/test/PlaceHolder.java");
        } else {
            this.getProject().getProperties().put("test", testPattern.toString());
        }
    }

    protected List<Resource> configureOptimisedTestSet(Project antProj) {
        List<String> includes = this.optimizeIncludes;
        List<String> excludes = this.optimizeExcludes;
        if (includes == null && excludes == null) {
            this.getLog().debug((CharSequence)"No clover excludes or includes specified. Falling back to Surefire configuration.");
            Plugin surefirePlugin = this.lookupSurefirePlugin();
            if (surefirePlugin != null) {
                includes = this.extractNestedStrings("includes", surefirePlugin);
                excludes = this.extractNestedStrings("excludes", surefirePlugin);
            }
            if (includes == null) {
                includes = DEFAULT_INCLUDES;
            }
        }
        this.getLog().debug((CharSequence)new StringBuffer().append("Effective filtering: includes=").append(includes).append(", excludes=").append(excludes).toString());
        CloverOptimizedTestSet testsToRun = new CloverOptimizedTestSet();
        testsToRun.setProject(antProj);
        testsToRun.setLogger((Logger)new MvnLogger(this.getLog()));
        testsToRun.setFullRunEvery(this.fullRunEvery);
        testsToRun.setDebug(this.debug);
        testsToRun.setSnapshotFile(new ConfigUtil(this).resolveSnapshotFile(this.snapshot));
        if (this.ordering != null) {
            CloverOptimizedTestSet.TestOrdering order = new CloverOptimizedTestSet.TestOrdering();
            order.setValue(this.ordering);
            testsToRun.setOrdering(order);
        }
        testsToRun.setMinimize(this.minimize);
        testsToRun.setEnabled(this.enabled);
        antProj.setProperty("clover.initstring", this.resolveCloverDatabase());
        antProj.setName(this.getProject().getName());
        List testSources = this.getProject().getTestCompileSourceRoots();
        for (String testSource : testSources) {
            this.addTestRoot(antProj, includes, excludes, testsToRun, testSource);
        }
        return testsToRun.getOptimizedTestResource();
    }

    protected List<String> extractNestedStrings(String elementName, Plugin surefirePlugin) {
        Xpp3Dom config = (Xpp3Dom)surefirePlugin.getConfiguration();
        return config == null ? null : CloverOptimizerMojo.extractNestedStrings(elementName, config);
    }

    static List<String> extractNestedStrings(String childname, Xpp3Dom config) {
        Xpp3Dom subelement = config.getChild(childname);
        if (subelement != null) {
            Xpp3Dom[] children;
            LinkedList<String> result = new LinkedList<String>();
            for (Xpp3Dom child : children = subelement.getChildren()) {
                result.add(child.getValue());
            }
            return result;
        }
        return null;
    }

    private void addTestRoot(Project antProj, List<String> includes, List<String> excludes, CloverOptimizedTestSet testsToRun, String testRoot) {
        File testRootDir = new File(testRoot);
        if (!testRootDir.exists()) {
            return;
        }
        this.getLog().info((CharSequence)new StringBuffer().append("Adding fileset: directory=").append(testRootDir).append(", includes=").append(includes).append(", excludes=").append(excludes).toString());
        testsToRun.add((ResourceCollection)this.createFileSet(antProj, testRootDir, includes, excludes));
        if (this.alwaysRunTests != null) {
            FileSet alwaysRunFileSet = this.createFileSet(antProj, testRootDir, this.alwaysRunTests, null);
            CloverAlwaysRunTestSet alwaysRunTestSet = new CloverAlwaysRunTestSet();
            alwaysRunTestSet.setProject(antProj);
            alwaysRunTestSet.add((ResourceCollection)alwaysRunFileSet);
            testsToRun.add(alwaysRunTestSet);
        }
    }

    FileSet createFileSet(Project antProject, File directory, List<String> includes, List<String> excludes) {
        FileSet testFileSet = new FileSet();
        testFileSet.setProject(antProject);
        testFileSet.setDir(directory);
        List<String> includesExpanded = CloverOptimizerMojo.explodePaths(directory, includes);
        testFileSet.appendIncludes(includesExpanded.toArray(new String[includesExpanded.size()]));
        if (excludes != null && !excludes.isEmpty()) {
            List<String> excludesExpanded = CloverOptimizerMojo.explodePaths(directory, excludes);
            testFileSet.appendExcludes(excludesExpanded.toArray(new String[excludesExpanded.size()]));
        }
        return testFileSet;
    }

    private Plugin lookupSurefirePlugin() {
        String key = "org.apache.maven.plugins:maven-surefire-plugin";
        MavenProject mavenProject = this.getProject();
        if (mavenProject == null) {
            this.getLog().warn((CharSequence)"Maven execution project is null. Surefire configuration will be ignored.");
            return null;
        }
        List plugins = mavenProject.getBuildPlugins();
        for (Plugin plugin : plugins) {
            if (!"org.apache.maven.plugins:maven-surefire-plugin".equalsIgnoreCase(plugin.getKey())) continue;
            return plugin;
        }
        return null;
    }

    static List<String> explodePaths(File directory, List<String> paths) {
        LinkedList<String> explodedPaths = new LinkedList<String>();
        for (String path : paths) {
            if (path.trim().startsWith(REGEX_START)) {
                CloverOptimizerMojo.splitPathByRegexp(directory, explodedPaths, path);
                continue;
            }
            CloverOptimizerMojo.splitPathBySeparators(explodedPaths, path);
        }
        return explodedPaths;
    }

    private static List<File> dirTreeMatchingPattern(File dir, Pattern pattern) {
        LinkedList<File> matchedFiles = new LinkedList<File>();
        if (dir.isDirectory()) {
            for (String fileName : dir.list()) {
                matchedFiles.addAll(CloverOptimizerMojo.dirTreeMatchingPattern(new File(dir, fileName), pattern));
            }
        } else if (pattern.matcher(dir.getPath()).matches()) {
            matchedFiles.add(dir);
        }
        return matchedFiles;
    }

    private static void splitPathByRegexp(File directory, List<String> outputList, String pathRegex) {
        String regex = pathRegex.substring(pathRegex.indexOf(REGEX_START) + REGEX_START.length(), pathRegex.lastIndexOf(REGEX_END));
        Pattern pattern = Pattern.compile(regex);
        List<File> matchedFiles = CloverOptimizerMojo.dirTreeMatchingPattern(directory, pattern);
        for (File file : matchedFiles) {
            outputList.add(FileUtils.getRelativePath((File)directory, (File)file));
        }
    }

    private static void splitPathBySeparators(List<String> outputList, String path) {
        String[] splittedPaths;
        String ANT_PATTERN_SEPARATOR = "[, ]";
        for (String splittedPath : splittedPaths = path.split("[, ]")) {
            if (splittedPath.length() <= 0) continue;
            outputList.add(splittedPath);
        }
    }
}

