/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import com.atlassian.maven.plugin.clover.internal.AntPropertyHelper;
import com.atlassian.maven.plugin.clover.internal.CloverConfiguration;
import com.atlassian.maven.plugin.clover.internal.ConfigUtil;
import com.cenqua.clover.cfg.Interval;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.PropertyHelper;
import org.codehaus.plexus.resource.ResourceManager;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloverReportMojo
extends AbstractMavenReport
implements CloverConfiguration {
    private File reportDescriptor;
    private boolean resolveReportDescriptor;
    protected ArtifactResolver artifactResolver;
    protected List repositories;
    protected ArtifactFactory artifactFactory;
    protected ArtifactRepository localRepository;
    private String cloverDatabase;
    protected boolean singleCloverDatabase;
    private String cloverMergeDatabase;
    private File outputDirectory;
    private String historyDir;
    private int flushInterval;
    private boolean waitForFlush;
    private boolean generateHtml;
    private boolean generatePdf;
    private boolean generateXml;
    private boolean generateJson;
    private boolean generateHistorical;
    private String orderBy;
    private String contextFilters;
    private String title;
    private String titleAnchor;
    private String charset;
    private Renderer siteRenderer;
    private MavenProject project;
    private List<MavenProject> reactorProjects;
    private String licenseLocation;
    private String license;
    private ResourceManager resourceManager;
    private String span = Interval.DEFAULT_SPAN.toString();
    private boolean alwaysReport = true;
    static /* synthetic */ Class class$com$atlassian$maven$plugin$clover$CloverReportMojo;

    public void executeReport(Locale locale) throws MavenReportException {
        File mergedCloverDatabase;
        File singleModuleCloverDatabase;
        if (!this.canGenerateReport()) {
            this.getLog().info((CharSequence)"No report being generated for this module.");
        }
        MavenProject lastProject = this.getReactorProjects().get(this.getReactorProjects().size() - 1);
        MavenProject thisProject = this.getProject();
        if (this.isSingleCloverDatabase() && !thisProject.equals((Object)lastProject)) {
            this.getLog().info((CharSequence)"Skipping report generation until the final project in the reactor.");
            return;
        }
        try {
            AbstractCloverMojo.registerLicenseFile(this.project, this.resourceManager, this.licenseLocation, this.getLog(), this.getClass().getClassLoader(), this.license);
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("Failed to locate Clover license", (Exception)((Object)e));
        }
        this.outputDirectory.mkdirs();
        if (this.reportDescriptor == null) {
            this.reportDescriptor = this.resolveCloverDescriptor();
        } else if (!this.reportDescriptor.exists()) {
            try {
                this.reportDescriptor = AbstractCloverMojo.getResourceAsFile(this.project, this.resourceManager, this.reportDescriptor.getPath(), this.getLog(), this.getClass().getClassLoader());
            }
            catch (MojoExecutionException e) {
                throw new MavenReportException(new StringBuffer().append("Could not resolve report descriptor: ").append(this.reportDescriptor.getPath()).toString(), (Exception)((Object)e));
            }
        }
        this.getLog().info((CharSequence)new StringBuffer().append("Using Clover report descriptor: ").append(this.reportDescriptor.getAbsolutePath()).toString());
        if (this.title != null && this.title.startsWith("Unnamed")) {
            this.title = new StringBuffer().append(this.project.getArtifactId()).append(" ").append(this.project.getVersion()).toString();
        }
        if ((singleModuleCloverDatabase = new File(this.resolveCloverDatabase())).exists()) {
            this.createAllReportTypes(this.resolveCloverDatabase(), this.title);
        }
        if ((mergedCloverDatabase = new File(this.cloverMergeDatabase)).exists()) {
            this.createAllReportTypes(this.cloverMergeDatabase, new StringBuffer().append(this.title).append(" (Aggregated)").toString());
        }
    }

    private void createAllReportTypes(String database, String titlePrefix) throws MavenReportException {
        String outpath = this.outputDirectory.getAbsolutePath();
        if (this.generateHtml) {
            this.createReport(database, "html", titlePrefix, outpath, outpath, false);
        }
        if (this.generatePdf) {
            this.createReport(database, "pdf", titlePrefix, new StringBuffer().append(outpath).append("/clover.pdf").toString(), new StringBuffer().append(outpath).append("/historical.pdf").toString(), true);
        }
        if (this.generateXml) {
            this.createReport(database, "xml", titlePrefix, new StringBuffer().append(outpath).append("/clover.xml").toString(), null, false);
        }
        if (this.generateJson) {
            this.createReport(database, "json", titlePrefix, outpath, null, false);
        }
    }

    private void createReport(String database, String format, String title, String output, String historyOut, boolean summary) {
        Project antProject = new Project();
        antProject.init();
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper((Project)antProject);
        propertyHelper.setNext((PropertyHelper)new AntPropertyHelper(this.project, this.getLog()));
        antProject.setUserProperty("ant.file", this.reportDescriptor.getAbsolutePath());
        antProject.setCoreLoader(this.getClass().getClassLoader());
        this.addMavenProperties(antProject);
        antProject.setProperty("cloverdb", database);
        antProject.setProperty("output", output);
        antProject.setProperty("history", this.historyDir);
        antProject.setProperty("title", title == null ? "" : title);
        antProject.setProperty("titleAnchor", this.titleAnchor == null ? "" : this.titleAnchor);
        String projectDir = this.project.getBasedir().getPath();
        antProject.setProperty("projectDir", projectDir);
        antProject.setProperty("testPattern", "**/src/test/**");
        antProject.setProperty("filter", this.contextFilters != null ? this.contextFilters : "");
        antProject.setProperty("orderBy", this.orderBy);
        antProject.setProperty("charset", this.charset);
        antProject.setProperty("type", format);
        antProject.setProperty("span", this.span);
        antProject.setProperty("alwaysReport", new StringBuffer().append("").append(this.alwaysReport).toString());
        antProject.setProperty("summary", String.valueOf(summary));
        if (historyOut != null) {
            antProject.setProperty("historyout", historyOut);
        }
        AbstractCloverMojo.registerCloverAntTasks(antProject, this.getLog());
        ProjectHelper.configureProject((Project)antProject, (File)this.reportDescriptor);
        antProject.setBaseDir(this.project.getBasedir());
        String target = this.isHistoricalDirectoryValid(output) && historyOut != null ? "historical" : "current";
        antProject.executeTarget(target);
    }

    private void addMavenProperties(Project antProject) {
        Properties properties = this.getProject().getProperties();
        Iterator i$ = properties.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry objEntry;
            Map.Entry entry = objEntry = i$.next();
            this.getLog().debug((CharSequence)new StringBuffer().append("Setting Property: ").append(entry.getKey().toString()).append(" = ").append(entry.getValue().toString()).toString());
            antProject.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    private boolean isHistoricalDirectoryValid(String outFile) {
        boolean isValid = false;
        File dir = new File(this.historyDir);
        if (dir.exists()) {
            if (dir.listFiles().length > 0) {
                isValid = true;
            } else {
                this.getLog().warn((CharSequence)new StringBuffer().append("No Clover historical data found in [").append(this.historyDir).append("], skipping Clover ").append("historical report generation ([").append(outFile).append("])").toString());
            }
        } else {
            this.getLog().warn((CharSequence)new StringBuffer().append("Clover historical directory [").append(this.historyDir).append("] does not exist, skipping Clover ").append("historical report generation ([").append(outFile).append("])").toString());
        }
        return isValid;
    }

    public String getOutputName() {
        return "clover/index";
    }

    public String getDescription(Locale locale) {
        return CloverReportMojo.getBundle(locale).getString("report.clover.description");
    }

    private static ResourceBundle getBundle(Locale locale) {
        Class<?> clazz = class$com$atlassian$maven$plugin$clover$CloverReportMojo;
        if (clazz == null) {
            clazz = class$com$atlassian$maven$plugin$clover$CloverReportMojo = new CloverReportMojo[0].getClass().getComponentType();
        }
        return ResourceBundle.getBundle("clover-report", locale, clazz.getClassLoader());
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsoluteFile().toString();
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    public String getName(Locale locale) {
        return CloverReportMojo.getBundle(locale).getString("report.clover.name");
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        boolean canGenerate = false;
        AbstractCloverMojo.waitForFlush(this.waitForFlush, this.flushInterval);
        File singleModuleCloverDatabase = new File(this.resolveCloverDatabase());
        File mergedCloverDatabase = new File(this.cloverMergeDatabase);
        if (singleModuleCloverDatabase.exists() || mergedCloverDatabase.exists()) {
            if (this.generateHtml || this.generatePdf || this.generateXml) {
                canGenerate = true;
            }
        } else {
            this.getLog().warn((CharSequence)"No Clover database found, skipping report generation");
        }
        return canGenerate;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.outputDirectory = reportOutputDirectory != null && !reportOutputDirectory.getAbsolutePath().endsWith("clover") ? new File(reportOutputDirectory, "clover") : reportOutputDirectory;
    }

    protected File resolveCloverDescriptor() throws MavenReportException {
        if (this.resolveReportDescriptor) {
            this.getLog().info((CharSequence)"Attempting to resolve the clover-report configuration as an xml artifact.");
            Artifact artifact = this.artifactFactory.createArtifactWithClassifier(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "xml", "clover-report");
            try {
                this.artifactResolver.resolve(artifact, this.repositories, this.localRepository);
                return artifact.getFile();
            }
            catch (ArtifactResolutionException e) {
                this.getLog().warn((CharSequence)e.getMessage(), (Throwable)e);
            }
            catch (ArtifactNotFoundException e) {
                this.getLog().warn((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
        try {
            this.getLog().info((CharSequence)"Using /default-clover-report descriptor.");
            File file = AbstractCloverMojo.getResourceAsFile(this.project, this.resourceManager, "/default-clover-report.xml", this.getLog(), this.getClass().getClassLoader());
            file.deleteOnExit();
            return file;
        }
        catch (Exception e) {
            throw new MavenReportException("Could not resolve default-clover-report.xml. Please try specifying this via the maven.clover.reportDescriptor property.", e);
        }
    }

    @Override
    public String getCloverDatabase() {
        return this.cloverDatabase;
    }

    @Override
    public String resolveCloverDatabase() {
        return new ConfigUtil(this).resolveCloverDatabase();
    }

    @Override
    public List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    @Override
    public boolean isSingleCloverDatabase() {
        return this.singleCloverDatabase;
    }
}

