/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover.internal.instrumentation;

import com.atlassian.clover.spi.lang.Language;
import com.atlassian.maven.plugin.clover.MvnLogger;
import com.atlassian.maven.plugin.clover.internal.CompilerConfiguration;
import com.atlassian.maven.plugin.clover.internal.scanner.CloverSourceScanner;
import com.atlassian.maven.plugin.clover.internal.scanner.LanguageFileExtensionFilter;
import com.cenqua.clover.CloverInstr;
import com.cenqua.clover.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInstrumenter {
    private CompilerConfiguration configuration;
    String outputSourceDirectory;
    private static final String PROP_PROJECT_BUILD_SOURCEENCODING = "project.build.sourceEncoding";

    public AbstractInstrumenter(CompilerConfiguration configuration, String outputSourceDirectory) {
        this.configuration = configuration;
        this.outputSourceDirectory = outputSourceDirectory;
    }

    protected CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void instrument() throws MojoExecutionException {
        CloverSourceScanner scanner = this.getSourceScanner();
        Map<String, String[]> javaFilesToInstrument = scanner.getSourceFilesToInstrument(LanguageFileExtensionFilter.JAVA_LANGUAGE, true);
        if (javaFilesToInstrument.isEmpty()) {
            this.getConfiguration().getLog().info((CharSequence)new StringBuffer().append("No Clover instrumentation done on source files in: ").append(this.getCompileSourceRoots()).append(" as no matching sources files found (JAVA_LANGUAGE)").toString());
        } else {
            this.instrumentSources(javaFilesToInstrument, this.outputSourceDirectory);
        }
        Map<String, String[]> groovyFilesToInstrument = scanner.getSourceFilesToInstrument(LanguageFileExtensionFilter.GROOVY_LANGUAGE, true);
        if (!groovyFilesToInstrument.isEmpty()) {
            this.copyExcludedFiles(groovyFilesToInstrument, this.outputSourceDirectory);
        }
        if (this.configuration.copyExcludedFiles()) {
            Map<String, String[]> explicitlyExcludedFiles = scanner.getExcludedFiles();
            this.copyExcludedFiles(explicitlyExcludedFiles, this.outputSourceDirectory);
        }
    }

    public String redirectSourceDirectories() {
        return this.redirectSourceDirectories(this.outputSourceDirectory);
    }

    protected abstract CloverSourceScanner getSourceScanner();

    protected abstract String getSourceDirectory();

    protected abstract void setSourceDirectory(String var1);

    protected abstract List<String> getCompileSourceRoots();

    protected abstract void addCompileSourceRoot(String var1);

    private String redirectSourceDirectories(String targetDirectory) {
        String oldSourceDirectory = this.getSourceDirectory();
        if (new File(oldSourceDirectory).exists()) {
            this.setSourceDirectory(targetDirectory);
        }
        this.getConfiguration().getLog().debug((CharSequence)"Clover source directories before change:");
        this.logSourceDirectories();
        ArrayList<String> sourceRoots = new ArrayList<String>(this.getCompileSourceRoots());
        this.getCompileSourceRoots().removeAll(sourceRoots);
        CloverSourceScanner scanner = this.getSourceScanner();
        for (String sourceRoot : sourceRoots) {
            if (new File(oldSourceDirectory).exists() && sourceRoot.equals(oldSourceDirectory)) {
                if (scanner.isSourceRootForLanguage(sourceRoot, (Language)Language.Builtin.GROOVY)) {
                    this.addCompileSourceRoot(sourceRoot);
                    continue;
                }
                this.addCompileSourceRoot(this.getSourceDirectory());
                continue;
            }
            if (this.getConfiguration().includesAllSourceRoots() && this.isGeneratedSourcesDirectory(sourceRoot)) continue;
            this.addCompileSourceRoot(sourceRoot);
        }
        this.getConfiguration().getLog().debug((CharSequence)"Clover main source directories after change:");
        this.logSourceDirectories();
        return oldSourceDirectory;
    }

    private boolean isGeneratedSourcesDirectory(String sourceRoot) {
        String generatedSrcDirDefaultLifecycle = new StringBuffer().append(File.separator).append("target").append(File.separator).append("generated-sources").toString();
        String generatedSrcDirCloverLifecycle = new StringBuffer().append(File.separator).append("target").append(File.separator).append("clover").append(File.separator).append("generated-sources").toString();
        return sourceRoot.indexOf(generatedSrcDirDefaultLifecycle) != -1 || sourceRoot.indexOf(generatedSrcDirCloverLifecycle) != -1;
    }

    private void logSourceDirectories() {
        if (this.getConfiguration().getLog().isDebugEnabled()) {
            for (String sourceRoot : this.getCompileSourceRoots()) {
                this.getConfiguration().getLog().debug((CharSequence)new StringBuffer().append("[Clover]  source root [").append(sourceRoot).append("]").toString());
            }
        }
    }

    private void copyExcludedFiles(Map<String, String[]> excludedFiles, String targetDirectory) throws MojoExecutionException {
        for (String sourceRoot : excludedFiles.keySet()) {
            String[] filesInSourceRoot;
            for (String fileName : filesInSourceRoot = excludedFiles.get(sourceRoot)) {
                File srcFile = new File(sourceRoot, fileName);
                try {
                    this.configuration.getLog().debug((CharSequence)new StringBuffer().append("Copying excluded file: ").append(srcFile.getAbsolutePath()).append(" to ").append(targetDirectory).toString());
                    FileUtils.copyFile((File)srcFile, (File)new File(targetDirectory, srcFile.getPath().substring(sourceRoot.length())));
                }
                catch (IOException e) {
                    throw new MojoExecutionException(new StringBuffer().append("Failed to copy excluded file [").append(srcFile).append("] to [").append(targetDirectory).append("]").toString(), (Exception)e);
                }
            }
        }
    }

    private void instrumentSources(Map<String, String[]> filesToInstrument, String outputDir) throws MojoExecutionException {
        Logger.setInstance((Logger)new MvnLogger(this.configuration.getLog()));
        new File(outputDir).mkdirs();
        int result = CloverInstr.mainImpl((String[])this.createCliArgs(filesToInstrument, outputDir));
        if (result != 0) {
            throw new MojoExecutionException(new StringBuffer().append("Clover has failed to instrument the source files in the [").append(outputDir).append("] directory").toString());
        }
    }

    private String[] createCliArgs(Map<String, String[]> filesToInstrument, String outputDir) throws MojoExecutionException {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("-p");
        parameters.add(this.getConfiguration().getFlushPolicy());
        parameters.add("-f");
        parameters.add(new StringBuffer().append("").append(this.getConfiguration().getFlushInterval()).toString());
        parameters.add("-i");
        parameters.add(this.getConfiguration().resolveCloverDatabase());
        parameters.add("-d");
        parameters.add(outputDir);
        if (this.getConfiguration().getLog().isDebugEnabled()) {
            parameters.add("-v");
        }
        if (this.getConfiguration().getDistributedCoverage() != null && this.getConfiguration().getDistributedCoverage().isEnabled()) {
            parameters.add("--distributedCoverage");
            parameters.add(this.getConfiguration().getDistributedCoverage().toString());
        }
        if (this.getConfiguration().getJdk() != null) {
            if (this.getConfiguration().getJdk().equals("1.4")) {
                parameters.add("--source");
                parameters.add("1.4");
            } else if (this.getConfiguration().getJdk().equals("1.5")) {
                parameters.add("--source");
                parameters.add("1.5");
            } else if (this.getConfiguration().getJdk().equals("1.6")) {
                parameters.add("--source");
                parameters.add("1.6");
            } else if (this.getConfiguration().getJdk().equals("1.7")) {
                parameters.add("--source");
                parameters.add("1.7");
            } else {
                throw new MojoExecutionException(new StringBuffer().append("Unsupported jdk version [").append(this.getConfiguration().getJdk()).append("]. Valid values are [1.4], [1.5], [1.6] and [1.7]").toString());
            }
        }
        if (!this.getConfiguration().isUseFullyQualifiedJavaLang()) {
            parameters.add("--dontFullyQualifyJavaLang");
        }
        if (this.getConfiguration().getEncoding() != null) {
            parameters.add("--encoding");
            parameters.add(this.getConfiguration().getEncoding());
        } else if (this.getConfiguration().getProject().getProperties().get(PROP_PROJECT_BUILD_SOURCEENCODING) != null) {
            parameters.add("--encoding");
            parameters.add(this.getConfiguration().getProject().getProperties().get(PROP_PROJECT_BUILD_SOURCEENCODING).toString());
        }
        if (this.getConfiguration().getInstrumentation() != null) {
            parameters.add("--instrlevel");
            parameters.add(this.getConfiguration().getInstrumentation());
        }
        for (String srcDir : filesToInstrument.keySet()) {
            String[] filesInSourceRoot;
            for (String s : filesInSourceRoot = filesToInstrument.get(srcDir)) {
                File file = new File(srcDir, s);
                parameters.add(file.getPath());
            }
        }
        this.addCustomContexts(parameters, this.getConfiguration().getMethodContexts().entrySet(), "-mc");
        this.addCustomContexts(parameters, this.getConfiguration().getStatementContexts().entrySet(), "-sc");
        if (this.getConfiguration().getLog().isDebugEnabled()) {
            this.getConfiguration().getLog().debug((CharSequence)"Parameter list being passed to Clover CLI:");
            for (String param : parameters) {
                this.getConfiguration().getLog().debug((CharSequence)new StringBuffer().append("  parameter = [").append(param).append("]").toString());
            }
        }
        return parameters.toArray(new String[parameters.size()]);
    }

    private void addCustomContexts(List<String> parameters, Set<Map.Entry<String, String>> contexts, String flag) {
        for (Map.Entry<String, String> entry : contexts) {
            parameters.add(flag);
            parameters.add(new StringBuffer().append(entry.getKey()).append("=").append(entry.getValue()).toString());
        }
    }
}

