/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover.internal;

import com.atlassian.maven.plugin.clover.MvnLogBuildListener;
import com.atlassian.maven.plugin.clover.internal.CloverConfiguration;
import com.atlassian.maven.plugin.clover.internal.ConfigUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Taskdef;
import org.codehaus.plexus.resource.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCloverMojo
extends AbstractMojo
implements CloverConfiguration {
    protected String cloverOutputDirectory;
    private String cloverDatabase;
    protected File snapshot;
    private boolean singleCloverDatabase;
    private String cloverMergeDatabase;
    protected String licenseLocation;
    protected String license;
    private String flushPolicy;
    private int flushInterval;
    private boolean waitForFlush;
    private String jdk;
    private MavenProject project;
    private ResourceManager resourceManager;
    protected boolean skip;
    protected boolean debug;
    private List<MavenProject> reactorProjects;

    public void execute() throws MojoExecutionException {
        this.registerLicenseFile();
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    protected void registerLicenseFile() throws MojoExecutionException {
        AbstractCloverMojo.registerLicenseFile(this.project, this.getResourceManager(), this.licenseLocation, this.getLog(), this.getClass().getClassLoader(), this.license);
    }

    public static void registerLicenseFile(MavenProject project, ResourceManager resourceManager, String licenseLocation, Log logger, ClassLoader classloader, String licenseCert) throws MojoExecutionException {
        if (licenseCert != null) {
            logger.debug((CharSequence)("Full license supplied. Length: '" + licenseCert.length() + "'. License location: '" + licenseLocation + "' will be ignored."));
            System.setProperty("clover.license.cert", licenseCert);
            return;
        }
        logger.debug((CharSequence)("Using licenseLocation '" + licenseLocation + "'"));
        if (licenseLocation == null) {
            logger.info((CharSequence)"No 'maven.clover.licenseLocation' configured. Using default evaluation license.");
            licenseLocation = "/clover.license";
        }
        File licenseFile = AbstractCloverMojo.getResourceAsFile(project, resourceManager, licenseLocation, logger, classloader);
        logger.debug((CharSequence)("Using license file [" + licenseFile.getPath() + "]"));
        System.setProperty("clover.license.path", licenseFile.getPath());
    }

    public static File getResourceAsFile(MavenProject project, ResourceManager resourceManager, String resourceLocation, Log logger, ClassLoader classloader) throws MojoExecutionException {
        logger.debug((CharSequence)("Getting resource: '" + resourceLocation + "'"));
        resourceManager.addSearchPath("url", "");
        resourceManager.addSearchPath("file", project.getFile().getParentFile().getAbsolutePath());
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classloader);
            try {
                logger.debug((CharSequence)("Attempting to load resource from [" + resourceLocation + "] ..."));
                File outputFile = File.createTempFile("mvn", "resource");
                outputFile.deleteOnExit();
                File file = resourceManager.getResourceAsFile(resourceLocation, outputFile.getPath());
                return file;
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to load resource as file [" + resourceLocation + "]", e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    public static void registerCloverAntTasks(Project antProject, Log log) {
        antProject.addBuildListener((BuildListener)new MvnLogBuildListener(log));
        Taskdef taskdef = (Taskdef)antProject.createTask("taskdef");
        taskdef.init();
        taskdef.setResource("cloverlib.xml");
        taskdef.execute();
    }

    public static void waitForFlush(boolean waitForFlush, int flushInterval) {
        if (waitForFlush) {
            try {
                Thread.sleep(2 * flushInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected boolean areCloverDatabasesAvailable() {
        boolean shouldRun = false;
        File singleModuleCloverDatabase = new File(this.resolveCloverDatabase());
        File mergedCloverDatabase = new File(this.cloverMergeDatabase);
        if (singleModuleCloverDatabase.exists() || mergedCloverDatabase.exists()) {
            shouldRun = true;
        }
        return shouldRun;
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    public boolean getWaitForFlush() {
        return this.waitForFlush;
    }

    public String getJdk() {
        return this.jdk;
    }

    @Override
    public String getCloverDatabase() {
        return this.cloverDatabase;
    }

    @Override
    public String resolveCloverDatabase() {
        return new ConfigUtil(this).resolveCloverDatabase();
    }

    protected String getCloverMergeDatabase() {
        return this.cloverMergeDatabase;
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    public String getFlushPolicy() {
        return this.flushPolicy;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setLicenseLocation(String licenseLocation) {
        this.licenseLocation = licenseLocation;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    @Override
    public List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    @Override
    public boolean isSingleCloverDatabase() {
        return this.singleCloverDatabase;
    }

    protected boolean isLastProjectInReactor() {
        MavenProject lastProject = this.getReactorProjects().get(this.getReactorProjects().size() - 1);
        MavenProject thisProject = this.getProject();
        return thisProject.equals((Object)lastProject);
    }

    protected boolean isModuleOfProject(MavenProject parentProject, MavenProject potentialModule) {
        boolean result = false;
        List modules = parentProject.getModules();
        if (modules != null) {
            File parentBaseDir = parentProject.getBasedir();
            for (String module : modules) {
                File moduleBaseDir = new File(parentBaseDir, module);
                try {
                    String rhs;
                    String lhs = potentialModule.getBasedir().getCanonicalPath();
                    if (!lhs.equals(rhs = moduleBaseDir.getCanonicalPath())) continue;
                    result = true;
                    break;
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)"error encountered trying to resolve canonical module paths");
                }
            }
        }
        return result;
    }

    protected List<MavenProject> getModuleProjects(MavenProject project, int levels) {
        boolean infinite;
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        boolean bl = infinite = levels == -1;
        if (this.getReactorProjects() != null && (infinite || levels > 0)) {
            for (MavenProject reactorProject : this.getReactorProjects()) {
                if (!this.isModuleOfProject(project, reactorProject)) continue;
                projects.add(reactorProject);
                if (project == reactorProject) {
                    projects.add(project);
                    continue;
                }
                projects.addAll(this.getModuleProjects(reactorProject, infinite ? levels : levels - 1));
            }
        }
        return projects;
    }

    protected List<MavenProject> getDescendentModuleProjects(MavenProject project) {
        return this.getModuleProjects(project, -1);
    }
}

