/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover.internal.scanner;

import com.atlassian.maven.plugin.clover.internal.CompilerConfiguration;
import com.atlassian.maven.plugin.clover.internal.scanner.CloverSourceScanner;
import com.atlassian.maven.plugin.clover.internal.scanner.LanguageFileExtensionFilter;
import com.atlassian.maven.plugin.clover.internal.scanner.LanguageFileFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.selectors.DependSelector;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSourceScanner
implements CloverSourceScanner {
    @NotNull
    private final CompilerConfiguration configuration;
    @NotNull
    private final File targetDir;

    public AbstractSourceScanner(@NotNull CompilerConfiguration configuration, @NotNull String outputSourceDirectory) {
        this.configuration = configuration;
        this.targetDir = new File(outputSourceDirectory);
    }

    @Override
    public Map<String, String[]> getExcludedFiles() {
        Map<String, String[]> excludedFiles = this.computeExcludedFiles(this.getDirectoryScanner());
        this.removeGroovySourceRoot(excludedFiles.keySet());
        return excludedFiles;
    }

    @Override
    public Map<String, String[]> getSourceFilesToInstrument() {
        return this.getSourceFilesToInstrument(LanguageFileExtensionFilter.ANY_LANGUAGE, false);
    }

    @Override
    public Map<String, String[]> getSourceFilesToInstrument(LanguageFileFilter languageFileFilter, boolean skipGroovySourceDirectory) {
        Map<String, String[]> includedFiles = this.computeIncludedFiles(this.getDirectoryScanner(), languageFileFilter);
        if (skipGroovySourceDirectory) {
            this.removeGroovySourceRoot(includedFiles.keySet());
        }
        return includedFiles;
    }

    protected abstract List<String> getCompileSourceRoots();

    protected abstract String getSourceDirectory();

    protected CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    protected abstract void removeGroovySourceRoot(@NotNull Set<String> var1);

    protected void removeSourceRoot(Set<String> sourceRoots, String sourceRootToRemove) {
        Iterator<String> iter = sourceRoots.iterator();
        while (iter.hasNext()) {
            String sourceRoot = iter.next();
            if (!sourceRoot.endsWith(sourceRootToRemove)) continue;
            iter.remove();
        }
    }

    private DirectoryScanner getDirectoryScanner() {
        Set<String> includes = this.getConfiguration().getIncludes();
        Set<String> excludes = this.getConfiguration().getExcludes();
        this.configuration.getLog().debug((CharSequence)("excludes patterns = " + excludes));
        this.configuration.getLog().debug((CharSequence)("includes patterns = " + includes));
        DirectoryScanner dirScan = new DirectoryScanner();
        dirScan.addExcludes(excludes.toArray(new String[excludes.size()]));
        dirScan.setIncludes(includes.toArray(new String[includes.size()]));
        dirScan.addDefaultExcludes();
        DependSelector selector = new DependSelector();
        selector.setTargetdir(this.targetDir);
        dirScan.setSelectors(new FileSelector[]{selector});
        return dirScan;
    }

    private Map<String, String[]> computeExcludedFiles(final DirectoryScanner scanner) {
        final HashMap<String, String[]> files = new HashMap<String, String[]>();
        this.visitSourceRoots(new SourceRootVisitor(){

            @Override
            public void visitDir(File dir) {
                scanner.setBasedir(dir);
                Set<String> configurationIncludes = AbstractSourceScanner.this.getConfiguration().getIncludes();
                String[] includes = AbstractSourceScanner.this.concatArrays(configurationIncludes.toArray(new String[configurationIncludes.size()]), DirectoryScanner.getDefaultExcludes());
                scanner.setIncludes(includes);
                scanner.scan();
                String[] sourcesToAdd = AbstractSourceScanner.this.concatArrays(scanner.getExcludedFiles(), scanner.getNotIncludedFiles());
                AbstractSourceScanner.this.configuration.getLog().debug((CharSequence)("excluding files from instrumentation = " + Arrays.asList(sourcesToAdd)));
                if (sourcesToAdd.length > 0) {
                    files.put(dir.getPath(), sourcesToAdd);
                }
            }
        });
        return files;
    }

    private Map<String, String[]> computeIncludedFiles(final DirectoryScanner scanner, final LanguageFileFilter languageFilter) {
        final HashMap<String, String[]> files = new HashMap<String, String[]>();
        this.visitSourceRoots(new SourceRootVisitor(){

            @Override
            public void visitDir(File dir) {
                scanner.setBasedir(dir);
                scanner.scan();
                String[] sourcesToAdd = languageFilter.filter(scanner.getIncludedFiles());
                if (sourcesToAdd.length > 0) {
                    AbstractSourceScanner.this.configuration.getLog().debug((CharSequence)("including files for instrumentation = " + Arrays.asList(sourcesToAdd)));
                    files.put(dir.getAbsolutePath(), sourcesToAdd);
                }
            }
        });
        return files;
    }

    private String[] concatArrays(String[] a1, String[] a2) {
        String[] result = new String[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return result;
    }

    private boolean isGeneratedSourcesDirectory(String sourceRoot) {
        String generatedSrcDirDefaultLifecycle = File.separator + "target" + File.separator + "generated-sources";
        String generatedSrcDirCloverLifecycle = File.separator + "target" + File.separator + "clover" + File.separator + "generated-sources";
        return sourceRoot.indexOf(generatedSrcDirDefaultLifecycle) != -1 || sourceRoot.indexOf(generatedSrcDirCloverLifecycle) != -1;
    }

    private List<String> getResolvedSourceRoots() {
        ArrayList<String> sourceRoots = new ArrayList<String>();
        if (this.getConfiguration().isIncludesAllSourceRoots()) {
            sourceRoots.addAll(this.getCompileSourceRoots());
        } else {
            for (String sourceRoot : this.getCompileSourceRoots()) {
                if (this.isGeneratedSourcesDirectory(sourceRoot)) continue;
                sourceRoots.add(sourceRoot);
            }
        }
        return sourceRoots;
    }

    private void visitSourceRoots(SourceRootVisitor visitor) {
        for (String resolvedSourceRoot : this.getResolvedSourceRoots()) {
            File sourceRoot = new File(resolvedSourceRoot);
            if (!sourceRoot.exists()) continue;
            visitor.visitDir(sourceRoot);
        }
    }

    private static interface SourceRootVisitor {
        public void visitDir(File var1);
    }
}

