/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover.internal.scanner;

import com.atlassian.clover.spi.lang.Language;
import com.atlassian.maven.plugin.clover.internal.scanner.LanguageFileFilter;
import java.util.ArrayList;
import java.util.Set;

public abstract class LanguageFileExtensionFilter
implements LanguageFileFilter {
    public static final LanguageFileFilter ANY_LANGUAGE = new LanguageFileExtensionFilter(){

        @Override
        public String[] filter(String[] inputFiles) {
            return inputFiles;
        }

        public String toString() {
            return "ANY_LANGUAGE";
        }
    };
    public static final LanguageFileFilter JAVA_LANGUAGE = new LanguageFileExtensionFilter(){

        @Override
        public String[] filter(String[] inputFiles) {
            return this.filter(inputFiles, Language.Builtin.JAVA.getFileExtensions());
        }

        public String toString() {
            return "JAVA_LANGUAGE";
        }
    };
    public static final LanguageFileFilter GROOVY_LANGUAGE = new LanguageFileExtensionFilter(){

        @Override
        public String[] filter(String[] inputFiles) {
            return this.filter(inputFiles, Language.Builtin.GROOVY.getFileExtensions());
        }

        public String toString() {
            return "GROOVY_LANGUAGE";
        }
    };

    @Override
    public abstract String[] filter(String[] var1);

    protected String[] filter(String[] inputFiles, Set<String> fileExtensions) {
        if (inputFiles == null) {
            return null;
        }
        ArrayList<String> filteredFiles = new ArrayList<String>(inputFiles.length);
        for (String inputFile : inputFiles) {
            String fileExt;
            int lastDotIndex = inputFile.lastIndexOf(46);
            if (lastDotIndex == -1 || !fileExtensions.contains(fileExt = inputFile.substring(lastDotIndex))) continue;
            filteredFiles.add(inputFile);
        }
        return filteredFiles.toArray(new String[filteredFiles.size()]);
    }
}

