/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.xmlrpc;

import com.atlassian.xmlrpc.AuthenticationInfo;
import com.atlassian.xmlrpc.Binder;
import com.atlassian.xmlrpc.BinderTypeFactory;
import com.atlassian.xmlrpc.BindingException;
import com.atlassian.xmlrpc.ConnectionInfo;
import com.atlassian.xmlrpc.RPCCallMethodInterceptor;
import com.atlassian.xmlrpc.ServiceObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcCommonsTransportFactory;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.XmlRpcController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBinder
implements Binder {
    @Override
    public <T> T bind(Class<T> bindClass, URL url) throws BindingException {
        return this.bind(bindClass, url, new ConnectionInfo());
    }

    @Override
    public <T> T bind(Class<T> bindClass, URL url, AuthenticationInfo authInfo) throws BindingException {
        ConnectionInfo info = new ConnectionInfo();
        info.setUsername(authInfo.getUsername());
        info.setPassword(authInfo.getPassword());
        return this.bind(bindClass, url, info);
    }

    @Override
    public <T> T bind(Class<T> bindClass, URL url, ConnectionInfo connectionInfo) throws BindingException {
        if (!bindClass.isInterface()) {
            throw new BindingException("Class " + bindClass.getName() + "is not an interface");
        }
        ServiceObject serviceObject = bindClass.getAnnotation(ServiceObject.class);
        if (serviceObject == null) {
            throw new BindingException("Could not find ServiceObject annotation on " + bindClass.getName());
        }
        RPCCallMethodInterceptor interceptor = new RPCCallMethodInterceptor(this.getXmlRpcClient(url, connectionInfo), serviceObject.value());
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{bindClass}, (InvocationHandler)interceptor);
    }

    private XmlRpcClient getXmlRpcClient(URL url, ConnectionInfo connectionInfo) {
        XmlRpcClientConfigImpl clientConfig = new XmlRpcClientConfigImpl();
        clientConfig.setServerURL(url);
        clientConfig.setEnabledForExceptions(true);
        if (connectionInfo != null) {
            clientConfig.setBasicUserName(connectionInfo.getUsername());
            clientConfig.setBasicPassword(connectionInfo.getPassword());
            clientConfig.setBasicEncoding(connectionInfo.getEncoding());
            clientConfig.setGzipCompressing(connectionInfo.isGzip());
            clientConfig.setGzipRequesting(connectionInfo.isGzip());
            clientConfig.setReplyTimeout(connectionInfo.getTimeout());
            clientConfig.setConnectionTimeout(connectionInfo.getTimeout());
            clientConfig.setTimeZone(connectionInfo.getTimeZone());
        }
        XmlRpcClient client = new XmlRpcClient();
        client.setTypeFactory((TypeFactory)new BinderTypeFactory((XmlRpcController)client));
        client.setTransportFactory((XmlRpcTransportFactory)new XmlRpcCommonsTransportFactory(client));
        client.setConfig((XmlRpcClientConfig)clientConfig);
        return client;
    }
}

