/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.xmlrpc;

import com.atlassian.xmlrpc.ServiceBean;
import com.atlassian.xmlrpc.ServiceBeanField;
import com.atlassian.xmlrpc.ServiceMethod;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.xmlrpc.client.XmlRpcClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPCCallMethodInterceptor
implements InvocationHandler {
    private final XmlRpcClient client;
    private final String serviceObject;

    public RPCCallMethodInterceptor(XmlRpcClient client, String serviceObject) {
        this.client = client;
        this.serviceObject = serviceObject;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] args) throws Throwable {
        String methodName = this.getMethodName(method);
        try {
            Object returnValue = this.client.execute(this.serviceObject + "." + methodName, (List)this.convertArguments(args));
            returnValue = this.convertReturnValue(method, returnValue);
            if (returnValue != null && !method.getReturnType().equals(Void.class)) {
                return returnValue;
            }
            return Void.TYPE;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not execute RPC method " + methodName, e);
        }
    }

    private String getMethodName(Method method) {
        String methodName = method.getName();
        ServiceMethod serviceMethod = method.getAnnotation(ServiceMethod.class);
        if (serviceMethod != null && serviceMethod.value() != null) {
            methodName = serviceMethod.value();
        }
        return methodName;
    }

    private Class getReturnBeanType(Method method) {
        Class returnType;
        Type resultType;
        ParameterizedType typeParam;
        if (method.getReturnType().isAnnotationPresent(ServiceBean.class)) {
            return method.getReturnType();
        }
        Type type = method.getGenericReturnType();
        if (type instanceof ParameterizedType && (typeParam = (ParameterizedType)type).getActualTypeArguments().length == 1 && (resultType = typeParam.getActualTypeArguments()[0]) instanceof Class && (returnType = (Class)resultType).isAnnotationPresent(ServiceBean.class)) {
            return returnType;
        }
        return null;
    }

    private Vector convertArguments(Object[] objects) {
        if (objects == null) {
            return new Vector();
        }
        ArrayList<Object> args = new ArrayList<Object>();
        for (Object o : objects) {
            if (o instanceof Collection) {
                args.add(((Collection)o).toArray());
                continue;
            }
            args.add(o);
        }
        return new Vector(args);
    }

    private Object convertReturnValue(Method method, Object returnValue) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (returnValue == null) {
            return null;
        }
        Class beanType = this.getReturnBeanType(method);
        if (returnValue.getClass().isArray()) {
            Object[] objArray = (Object[])returnValue;
            ArrayList list = new ArrayList(Arrays.asList(objArray));
            if (beanType != null) {
                list = this.mapBeanCollection(list, beanType);
            }
            return list;
        }
        if (returnValue instanceof HashMap && beanType != null) {
            returnValue = this.mapBean((Map)returnValue, beanType);
        }
        return returnValue;
    }

    private ArrayList mapBeanCollection(Collection<HashMap> result, Class beanType) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList<Object> beanCollection = new ArrayList<Object>();
        for (HashMap map : result) {
            Object beanInstance = this.mapBean(map, beanType);
            beanCollection.add(beanInstance);
        }
        return beanCollection;
    }

    private Object mapBean(Map map, Class beanType) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Object beanInstance = beanType.newInstance();
        this.mapToBean(beanInstance, map);
        return beanInstance;
    }

    private void mapToBean(Object bean, Map map) throws IllegalAccessException, InvocationTargetException {
        BeanUtils.populate((Object)bean, (Map)this.removeNullValues(this.mapArraysToLists(this.remapPropertyNames(bean, map))));
    }

    private Map mapArraysToLists(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>(map);
        for (String key : result.keySet()) {
            Object value = result.get(key);
            if (value == null || !value.getClass().isArray()) continue;
            result.put(key, Arrays.asList((Object[])value));
        }
        return result;
    }

    private Map removeNullValues(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    private Map remapPropertyNames(Object bean, Map map) {
        HashMap result = new HashMap(map);
        for (PropertyDescriptor descriptor : PropertyUtils.getPropertyDescriptors((Object)bean)) {
            Method writeMethod = descriptor.getWriteMethod();
            if (writeMethod == null) continue;
            ServiceBeanField beanField = writeMethod.getAnnotation(ServiceBeanField.class);
            if (beanField != null && beanField.value() != null && !beanField.value().equals("")) {
                Object data = result.get(beanField.value());
                result.remove(beanField.value());
                result.put(descriptor.getName(), data);
                continue;
            }
            result.put(descriptor.getName(), null);
        }
        return result;
    }
}

