/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.xmlrpc;

import com.atlassian.xmlrpc.ServiceMethod;
import java.lang.reflect.Method;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.server.PropertyHandlerMapping;

public class BinderPropertyHandlerMapping
extends PropertyHandlerMapping {
    public BinderPropertyHandlerMapping() {
        this.setVoidMethodEnabled(true);
    }

    protected void registerPublicMethods(String pKey, Class pType) throws XmlRpcException {
        super.registerPublicMethods(pKey, pType);
        for (Method method : pType.getMethods()) {
            String name;
            Object value;
            if (!this.isHandlerMethod(method)) continue;
            ServiceMethod serviceMethod = null;
            for (Class<?> interfaceType : pType.getInterfaces()) {
                Method methodOnInterface;
                Method[] arr$ = interfaceType.getMethods();
                int len$ = arr$.length;
                for (int i$ = 0; !(i$ >= len$ || (methodOnInterface = arr$[i$]).getName().equals(method.getName()) && this.compareArgs(method, methodOnInterface) && (serviceMethod = methodOnInterface.getAnnotation(ServiceMethod.class)) != null); ++i$) {
                }
                if (serviceMethod != null) break;
            }
            if (serviceMethod == null || serviceMethod.value() == null || (value = this.handlerMap.get(name = pKey + "." + method.getName())) == null) continue;
            this.handlerMap.remove(name);
            name = pKey + "." + serviceMethod.value();
            this.handlerMap.put(name, value);
        }
    }

    private boolean compareArgs(Method method1, Method method2) {
        Class<?>[] param2;
        Class<?>[] param1 = method1.getParameterTypes();
        if (param1.length != (param2 = method2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < param1.length; ++i) {
            if (param1[i].equals(param2[i])) continue;
            return false;
        }
        return true;
    }
}

