/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.xmlrpc.spring;

import com.atlassian.xmlrpc.BinderRequestProcessorFactoryFactory;
import com.atlassian.xmlrpc.BinderXmlRpcServlet;
import com.atlassian.xmlrpc.ServiceObject;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.server.AbstractReflectiveHandlerMapping;
import org.apache.xmlrpc.server.PropertyHandlerMapping;
import org.apache.xmlrpc.server.RequestProcessorFactoryFactory;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class BinderSpringXmlRpcServlet
extends BinderXmlRpcServlet {
    public static final String SERVICE_LIST_BEAN_NAME = "serviceListBeanName";
    public static final String AUTH_HANDLER_BEAN_NAME = "authHandlerBeanName";
    private ApplicationContext context;
    private List serviceObjects;

    public void init(ServletConfig pConfig) throws ServletException {
        ServletConfig proxiedConfig = this.getProxyServletConfig(pConfig);
        super.init(proxiedConfig);
        this.serviceObjects = this.getServiceObjects(pConfig);
        this.initAuthenticationHandler(pConfig);
        this.initRequestProcessorFactoryFactory();
        try {
            this.getXmlRpcServletServer().setHandlerMapping(this.newXmlRpcHandlerMapping());
        }
        catch (XmlRpcException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    protected ApplicationContext getApplicationContext() {
        if (this.context == null) {
            this.context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        }
        return this.context;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    private void initRequestProcessorFactoryFactory() throws ServletException {
        this.setRequestProcessorFactoryFactory((RequestProcessorFactoryFactory)new BinderRequestProcessorFactoryFactory(this.serviceObjects));
    }

    private void initAuthenticationHandler(ServletConfig pConfig) throws ServletException {
        String beanName = pConfig.getInitParameter(AUTH_HANDLER_BEAN_NAME);
        if (beanName == null) {
            return;
        }
        Object o = this.context.getBean(beanName);
        if (!(o instanceof AbstractReflectiveHandlerMapping.AuthenticationHandler)) {
            throw new ServletException(beanName + " is supposed to be a implementation of AuthenticationHandler but was " + o.getClass().getName());
        }
        this.setAuthenticationHandler((AbstractReflectiveHandlerMapping.AuthenticationHandler)o);
    }

    protected XmlRpcHandlerMapping newXmlRpcHandlerMapping() throws XmlRpcException {
        try {
            return this.newPropertyHandlerMapping(null);
        }
        catch (IOException e) {
            throw new XmlRpcException("Should never be thrown", (Throwable)e);
        }
    }

    private List getServiceObjects(ServletConfig pConfig) throws ServletException {
        String beanName = pConfig.getInitParameter(SERVICE_LIST_BEAN_NAME);
        if (beanName == null) {
            throw new ServletException("Parameter not specified serviceListBeanName");
        }
        List serviceList = (List)this.getApplicationContext().getBean(beanName);
        if (serviceList == null) {
            throw new ServletException("Could not find bean " + beanName);
        }
        return serviceList;
    }

    protected PropertyHandlerMapping newPropertyHandlerMapping(URL url) throws IOException, XmlRpcException {
        PropertyHandlerMapping handlerMapping = super.newPropertyHandlerMapping(url);
        if (this.serviceObjects != null) {
            for (Object service : this.serviceObjects) {
                String serviceObjectName = this.findServiceObjectNameForServiceObject(service);
                if (serviceObjectName == null) {
                    throw new XmlRpcException("Could not get Service Object name for service " + service.getClass().getName());
                }
                handlerMapping.addHandler(serviceObjectName, service.getClass());
            }
        }
        return handlerMapping;
    }

    private String findServiceObjectNameForServiceObject(Object service) {
        String serviceObjectName = null;
        for (Class<?> interfaceType : service.getClass().getInterfaces()) {
            ServiceObject serviceObject = interfaceType.getAnnotation(ServiceObject.class);
            if (serviceObject == null) continue;
            serviceObjectName = serviceObject.value();
        }
        return serviceObjectName;
    }

    private ServletConfig getProxyServletConfig(ServletConfig config) {
        IgnoreParamsInvocationHandler handler = new IgnoreParamsInvocationHandler(config);
        return (ServletConfig)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{ServletConfig.class}, (InvocationHandler)handler);
    }

    private class IgnoreParamsInvocationHandler
    implements InvocationHandler {
        private final ServletConfig config;

        public IgnoreParamsInvocationHandler(ServletConfig config) {
            this.config = config;
        }

        public Object invoke(Object object, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getInitParameterNames")) {
                Enumeration enumeration = this.config.getInitParameterNames();
                return new EnumerationWrapper(enumeration);
            }
            return method.invoke((Object)this.config, args);
        }

        class EnumerationWrapper
        implements Enumeration {
            private final Iterator iterator;

            public EnumerationWrapper(Enumeration enumeration) {
                ArrayList<String> elements = new ArrayList<String>();
                do {
                    String element;
                    if (BinderSpringXmlRpcServlet.SERVICE_LIST_BEAN_NAME.equals(element = (String)enumeration.nextElement()) || BinderSpringXmlRpcServlet.AUTH_HANDLER_BEAN_NAME.equals(element)) continue;
                    elements.add(element);
                } while (enumeration.hasMoreElements());
                this.iterator = elements.iterator();
            }

            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            public Object nextElement() {
                return this.iterator.next();
            }
        }
    }
}

