/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.xmlrpc;

import com.atlassian.xmlrpc.ServiceBean;
import com.atlassian.xmlrpc.ServiceBeanField;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.ws.commons.util.NamespaceContextImpl;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.TypeFactoryImpl;
import org.apache.xmlrpc.common.XmlRpcController;
import org.apache.xmlrpc.common.XmlRpcStreamConfig;
import org.apache.xmlrpc.parser.NullParser;
import org.apache.xmlrpc.parser.TypeParser;
import org.apache.xmlrpc.serializer.MapSerializer;
import org.apache.xmlrpc.serializer.TypeSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class BinderTypeFactory
extends TypeFactoryImpl {
    public BinderTypeFactory(XmlRpcController controller) {
        super(controller);
    }

    public TypeSerializer getSerializer(XmlRpcStreamConfig pConfig, Object pObject) throws SAXException {
        if (this.isServiceBean(pObject)) {
            return new BeanSerializer((TypeFactory)this, pConfig);
        }
        return super.getSerializer(pConfig, pObject);
    }

    public TypeParser getParser(XmlRpcStreamConfig pConfig, NamespaceContextImpl pContext, String pURI, String pLocalName) {
        if ("nil".equals(pLocalName)) {
            return new NullParser();
        }
        return super.getParser(pConfig, pContext, pURI, pLocalName);
    }

    private boolean isServiceBean(Object object) {
        if (object != null && object.getClass() != null) {
            return object.getClass().isAnnotationPresent(ServiceBean.class);
        }
        return false;
    }

    public class BeanSerializer
    extends MapSerializer {
        public BeanSerializer(TypeFactory pTypeFactory, XmlRpcStreamConfig pConfig) {
            super(pTypeFactory, pConfig);
        }

        protected void writeData(ContentHandler pHandler, Object pData) throws SAXException {
            try {
                pData = this.getMap(pData);
            }
            catch (IllegalAccessException e) {
                throw new SAXException(e);
            }
            catch (InvocationTargetException e) {
                throw new SAXException(e);
            }
            catch (NoSuchMethodException e) {
                throw new SAXException(e);
            }
            super.writeData(pHandler, pData);
        }

        private Map getMap(Object object) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            HashMap<String, String> map = new HashMap<String, String>();
            for (PropertyDescriptor descriptor : PropertyUtils.getPropertyDescriptors((Object)object)) {
                if (descriptor.getReadMethod() == null || descriptor.getWriteMethod() == null) continue;
                String name = descriptor.getName();
                String value = BeanUtils.getProperty((Object)object, (String)name);
                Method writeMethod = descriptor.getWriteMethod();
                ServiceBeanField beanField = writeMethod.getAnnotation(ServiceBeanField.class);
                if (beanField != null && !beanField.value().equals("")) {
                    name = beanField.value();
                }
                map.put(name, value);
            }
            return map;
        }
    }
}

