/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class SysException
extends RuntimeException {
    private static final long serialVersionUID = -9183281406145817016L;
    private Stack myErrors = null;

    private static void printNestedErrorStack(SysException e) {
        Stack errors = e.getErrors();
        while (errors != null && !errors.empty()) {
            System.err.println("Nested exception is: ");
            Exception nxt = (Exception)errors.pop();
            if (nxt instanceof SysException) {
                SysException se = (SysException)nxt;
                nxt.printStackTrace();
                SysException.printNestedErrorStack(se);
                continue;
            }
            nxt.printStackTrace();
        }
    }

    private static void addStackTraceElementsToList(StackTraceElement[] elements, List list) {
        for (int i = 0; i < elements.length; ++i) {
            list.add(elements[i]);
        }
    }

    public SysException(String msg) {
        super(msg);
    }

    public SysException(String msg, Stack nestedList) {
        super(msg);
        this.myErrors = (Stack)nestedList.clone();
    }

    private void addStackTraceToList(List list) {
        StackTraceElement[] elements = super.getStackTrace();
        SysException.addStackTraceElementsToList(elements, list);
        Stack errors = this.getErrors();
        while (errors != null && !errors.empty()) {
            Exception e = (Exception)errors.pop();
            if (e instanceof SysException) {
                SysException se = (SysException)e;
                se.addStackTraceToList(list);
                continue;
            }
            elements = e.getStackTrace();
            SysException.addStackTraceElementsToList(elements, list);
        }
    }

    public Stack getErrors() {
        if (this.myErrors == null) {
            return null;
        }
        return (Stack)this.myErrors.clone();
    }

    public void printStackTrace() {
        super.printStackTrace();
        SysException.printNestedErrorStack(this);
    }

    public StackTraceElement[] getStackTrace() {
        ArrayList elements = new ArrayList();
        this.addStackTraceToList(elements);
        return elements.toArray(new StackTraceElement[0]);
    }
}

