/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta.hibernate4;

import com.atomikos.icatch.jta.UserTransactionImp;
import com.atomikos.icatch.jta.UserTransactionManager;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import org.hibernate.TransactionException;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatformException;

public class AtomikosPlatform
implements JtaPlatform {
    private static final long serialVersionUID = 1L;
    private final TransactionManager txMgr = new UserTransactionManager();
    private final UserTransaction userTx = new UserTransactionImp();

    public Object getTransactionIdentifier(Transaction transaction) {
        return transaction;
    }

    public void registerSynchronization(Synchronization synchronization) {
        try {
            this.txMgr.getTransaction().registerSynchronization(synchronization);
        }
        catch (Exception e) {
            throw new JtaPlatformException("Could not access JTA Transaction to register synchronization", (Throwable)e);
        }
    }

    public boolean canRegisterSynchronization() {
        try {
            if (this.txMgr.getTransaction() != null) {
                return this.txMgr.getTransaction().getStatus() == 0;
            }
        }
        catch (SystemException se) {
            throw new TransactionException("Could not determine transaction status", (Throwable)se);
        }
        return false;
    }

    public int getCurrentStatus() throws SystemException {
        return this.retrieveTransactionManager().getStatus();
    }

    public UserTransaction retrieveUserTransaction() {
        return this.userTx;
    }

    public TransactionManager retrieveTransactionManager() {
        return this.txMgr;
    }
}

