/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.datasource.pool.AbstractXPooledConnection;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.Reapable;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.jdbc.JdbcTransactionalResource;
import com.atomikos.datasource.xa.session.SessionHandleState;
import com.atomikos.datasource.xa.session.SessionHandleStateChangeListener;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.AtomikosConnectionProxy;
import com.atomikos.jdbc.JdbcConnectionProxyHelper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.XAConnection;

public class AtomikosXAPooledConnection
extends AbstractXPooledConnection {
    private SessionHandleState sessionHandleState;
    private XAConnection xaConnection;
    private Connection connection;

    public AtomikosXAPooledConnection(XAConnection xaConnection, JdbcTransactionalResource jdbcTransactionalResource, ConnectionPoolProperties props) throws SQLException {
        super(props);
        this.xaConnection = xaConnection;
        this.connection = xaConnection.getConnection();
        this.sessionHandleState = new SessionHandleState((XATransactionalResource)jdbcTransactionalResource, xaConnection.getXAResource());
        this.sessionHandleState.registerSessionHandleStateChangeListener(new SessionHandleStateChangeListener(){

            public void onTerminated() {
                Configuration.logDebug((String)("SessionHandleState terminated, firing XPooledConnectionTerminated event for " + (Object)((Object)AtomikosXAPooledConnection.this)));
                AtomikosXAPooledConnection.this.updateLastTimeReleased();
                AtomikosXAPooledConnection.this.fireOnXPooledConnectionTerminated();
            }
        });
    }

    public void destroy() {
        Configuration.logDebug((String)((Object)((Object)this) + ": destroying connection..."));
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                Configuration.logWarning((String)((Object)((Object)this) + ": error closing Connection: "), (Throwable)e);
            }
        }
        if (this.xaConnection != null) {
            try {
                this.xaConnection.close();
            }
            catch (SQLException e) {
                Configuration.logWarning((String)((Object)((Object)this) + ": error closing XAConnection: "), (Throwable)e);
            }
        }
        this.connection = null;
        this.xaConnection = null;
    }

    protected Reapable doCreateConnectionProxy(HeuristicMessage hmsg) throws CreateConnectionException {
        Configuration.logDebug((String)((Object)((Object)this) + ": creating connection proxy..."));
        JdbcConnectionProxyHelper.setIsolationLevel(this.connection, this.getDefaultIsolationLevel());
        return AtomikosConnectionProxy.newInstance(this.connection, this.sessionHandleState, hmsg);
    }

    protected void testUnderlyingConnection() throws CreateConnectionException {
        if (this.isErroneous()) {
            throw new CreateConnectionException((Object)((Object)this) + ": connection is erroneous");
        }
        String testQuery = this.getTestQuery();
        if (testQuery != null) {
            Configuration.logDebug((String)((Object)((Object)this) + ": testing connection with query [" + testQuery + "]"));
            Statement stmt = null;
            try {
                stmt = this.connection.createStatement();
                ResultSet rs = stmt.executeQuery(testQuery);
                rs.close();
                stmt.close();
            }
            catch (SQLException e) {
                throw new CreateConnectionException("Error executing testQuery", (Exception)e);
            }
            Configuration.logDebug((String)((Object)((Object)this) + ": connection tested OK"));
        } else {
            Configuration.logDebug((String)((Object)((Object)this) + ": no test query, skipping test"));
        }
    }

    public boolean isAvailable() {
        boolean available = false;
        available = this.sessionHandleState.isTerminated() && this.xaConnection != null;
        return available;
    }

    public boolean isErroneous() {
        return this.sessionHandleState.isErroneous();
    }

    public String toString() {
        return "an AtomikosXAPooledConnection with " + this.sessionHandleState;
    }

    public boolean isInTransaction(CompositeTransaction ct) {
        return this.sessionHandleState.isActiveInTransaction(ct);
    }

    public boolean canBeRecycledForCallingThread() {
        boolean ret = false;
        CompositeTransactionManager tm = Configuration.getCompositeTransactionManager();
        CompositeTransaction current = tm.getCompositeTransaction();
        if (current != null && current.getProperty("com.atomikos.icatch.jta.transaction") != null) {
            ret = this.sessionHandleState.isInactiveInTransaction(current);
        }
        return ret;
    }
}

