/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.nonxa;

import com.atomikos.beans.PropertyUtils;
import com.atomikos.datasource.pool.Reapable;
import com.atomikos.datasource.pool.XPooledConnection;
import com.atomikos.datasource.pool.XPooledConnectionEventListener;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.jdbc.AbstractConnectionProxy;
import com.atomikos.jdbc.AtomikosSQLException;
import com.atomikos.jdbc.JdbcConnectionProxyHelper;
import com.atomikos.jdbc.nonxa.AtomikosNonXAParticipant;
import com.atomikos.jdbc.nonxa.AtomikosNonXAPooledConnection;
import com.atomikos.jdbc.nonxa.JtaAwareNonXaConnection;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.ClassLoadingHelper;
import com.atomikos.util.DynamicProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class AtomikosThreadLocalConnection
extends AbstractConnectionProxy
implements JtaAwareNonXaConnection {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosThreadLocalConnection.class);
    private static final List<String> ENLISTMENT_METHODS = Arrays.asList("createStatement", "prepareStatement", "prepareCall");
    private static final List<String> CLOSE_METHODS = Arrays.asList("close");
    private static final List<String> XA_INCOMPATIBLE_METHODS = Arrays.asList("commit", "rollback", "setSavepoint", "releaseSavepoint");
    private static final List<String> NON_TRANSACTIONAL_METHOD_NAMES = Arrays.asList("equals", "hashCode", "notify", "notifyAll", "toString", "wait");
    private int useCount = 0;
    private CompositeTransaction transaction = null;
    private boolean stale = false;
    private AtomikosNonXAPooledConnection pooledConnection;
    private Connection wrapped;
    private boolean originalAutoCommitState;
    private AtomikosNonXAParticipant participant;
    private boolean readOnly;
    private String resourceName;

    static Object newInstance(AtomikosNonXAPooledConnection pooledConnection, String resourceName) {
        Object ret = null;
        Connection obj = pooledConnection.getConnection();
        Set interfaces = PropertyUtils.getAllImplementedInterfaces(obj.getClass());
        interfaces.add(Reapable.class);
        interfaces.add(DynamicProxy.class);
        Class[] interfaceClasses = interfaces.toArray(new Class[0]);
        HashSet<Class<Connection>> minimumSetOfInterfaces = new HashSet<Class<Connection>>();
        minimumSetOfInterfaces.add(Reapable.class);
        minimumSetOfInterfaces.add(DynamicProxy.class);
        minimumSetOfInterfaces.add(Connection.class);
        Class[] minimumSetOfInterfaceClasses = minimumSetOfInterfaces.toArray(new Class[0]);
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        classLoaders.add(Thread.currentThread().getContextClassLoader());
        classLoaders.add(obj.getClass().getClassLoader());
        classLoaders.add(AtomikosThreadLocalConnection.class.getClassLoader());
        ret = ClassLoadingHelper.newProxyInstance(classLoaders, (Class[])minimumSetOfInterfaceClasses, (Class[])interfaceClasses, (InvocationHandler)new AtomikosThreadLocalConnection(pooledConnection));
        DynamicProxy dproxy = (DynamicProxy)ret;
        AtomikosThreadLocalConnection c = (AtomikosThreadLocalConnection)dproxy.getInvocationHandler();
        c.resourceName = resourceName;
        return ret;
    }

    private AtomikosThreadLocalConnection(AtomikosNonXAPooledConnection pooledConnection) {
        this.pooledConnection = pooledConnection;
        this.wrapped = pooledConnection.getConnection();
        this.readOnly = pooledConnection.getReadOnly();
    }

    private void setStale() {
        this.stale = true;
    }

    private void resetForNextTransaction() {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo(this + ": resetting autoCommit to " + this.originalAutoCommitState);
            }
            this.wrapped.setAutoCommit(this.originalAutoCommitState);
        }
        catch (Exception ex) {
            LOGGER.logWarning("Failed to reset original autoCommit state: " + ex.getMessage(), (Throwable)ex);
        }
        this.setTransaction(null);
        this.participant = null;
    }

    boolean isStale() {
        return this.stale;
    }

    private void decUseCount() {
        --this.useCount;
        this.markForReuseIfPossible();
    }

    public void incUseCount() {
        ++this.useCount;
    }

    private void setTransaction(CompositeTransaction tx) {
        this.transaction = tx;
    }

    private void updateInTransaction() throws SQLException {
        CompositeTransactionManager ctm = Configuration.getCompositeTransactionManager();
        if (ctm == null) {
            return;
        }
        CompositeTransaction ct = ctm.getCompositeTransaction();
        if (ct != null && ct.getProperty("com.atomikos.icatch.jta.transaction") != null) {
            if (this.isInTransaction() && !this.isInTransaction(ct)) {
                AtomikosSQLException.throwAtomikosSQLException("Connection accessed by transaction " + ct.getTid() + " is already in use in another transaction: " + this.transaction.getTid() + " Non-XA connections are not compatible with nested transaction use.");
            }
            this.setTransaction(ct);
            if (this.participant == null) {
                this.participant = new AtomikosNonXAParticipant(this, this.resourceName);
                this.participant.setReadOnly(this.readOnly);
                ct.addParticipant((Participant)this.participant);
                this.originalAutoCommitState = this.wrapped.getAutoCommit();
                this.wrapped.setAutoCommit(false);
            }
        } else if (this.isInTransaction()) {
            this.transactionTerminated(false);
        }
    }

    @Override
    public Object invoke(Object o, Method m, Object[] args) throws Throwable {
        String methodName = m.getName();
        if (methodName.equals("getInvocationHandler")) {
            return this;
        }
        if (methodName.equals("reap")) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo(this + ": reap()...");
            }
            this.reap();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug(this + ": reap done.");
            }
            return null;
        }
        if (methodName.equals("isNoLongerInUse")) {
            return this.isNoLongerInUse();
        }
        if (methodName.equals("isInTransaction")) {
            return m.invoke((Object)this, args);
        }
        if (methodName.equals("isClosed")) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo(this + ": isClosed()...");
            }
            Boolean ret = this.isStale();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug(this + ": isClosed() returning " + ret);
            }
            return ret;
        }
        if (this.isStale() && !NON_TRANSACTIONAL_METHOD_NAMES.contains(methodName)) {
            if (!methodName.equals("close")) {
                AtomikosSQLException.throwAtomikosSQLException("Attempt to use connection after it was closed.");
            }
        } else if (this.isInTransaction()) {
            if (XA_INCOMPATIBLE_METHODS.contains(methodName)) {
                AtomikosSQLException.throwAtomikosSQLException("Cannot call method '" + methodName + "' while a global transaction is running");
            }
            if (methodName.equals("setAutoCommit") && args[0].equals(Boolean.TRUE)) {
                AtomikosSQLException.throwAtomikosSQLException("Cannot call 'setAutoCommit(true)' while a global transaction is running");
            }
            if (methodName.equals("getAutoCommit")) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.logInfo(this + ": getAutoCommit()...");
                }
                Boolean ret = Boolean.FALSE;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug(this + ": getAutoCommit() returning false.");
                }
                return ret;
            }
            CompositeTransactionManager ctm = Configuration.getCompositeTransactionManager();
            CompositeTransaction ct = ctm.getCompositeTransaction();
            if (ct != null && !this.isInTransaction(ct)) {
                AtomikosSQLException.throwAtomikosSQLException("Connection accessed by transaction " + ct.getTid() + " is already in use in another transaction: " + this.transaction.getTid() + " Non-XA connections are not compatible with nested transaction use.");
            }
        } else if (ENLISTMENT_METHODS.contains(methodName)) {
            this.updateInTransaction();
        }
        Object ret = null;
        if (CLOSE_METHODS.contains(methodName)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo(this + ": close...");
            }
            this.decUseCount();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug(this + ": close done.");
            }
            return null;
        }
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo(this + ": calling " + methodName + " on vendor connection...");
            }
            ret = m.invoke((Object)this.wrapped, args);
        }
        catch (Exception ex) {
            this.pooledConnection.setErroneous();
            JdbcConnectionProxyHelper.convertProxyError(ex, "Error delegating '" + methodName + "' call");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": " + methodName + " returning " + ret);
        }
        if (ret instanceof Statement) {
            Statement s = (Statement)ret;
            this.addStatement(s);
        }
        return ret;
    }

    private boolean isInTransaction() {
        return this.transaction != null;
    }

    boolean isInTransaction(CompositeTransaction ct) {
        boolean ret = false;
        CompositeTransaction tx = this.transaction;
        if (tx != null && ct != null) {
            ret = tx.isSameTransaction(ct);
        }
        return ret;
    }

    boolean isNoLongerInUse() {
        return this.useCount <= 0 && !this.isInTransaction();
    }

    private void markForReuseIfPossible() {
        if (this.isNoLongerInUse()) {
            LOGGER.logDebug("ThreadLocalConnection: detected reusability");
            this.setStale();
            this.pooledConnection.fireOnXPooledConnectionTerminated();
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("ThreadLocalConnection: not reusable yet");
        }
    }

    private void reap() {
        LOGGER.logWarning(this + ": reaping - check if the application closes connections correctly, or increase the reapTimeout value");
        this.setStale();
        this.useCount = 0;
        this.markForReuseIfPossible();
        this.pooledConnection.setErroneous();
        this.forceCloseAllPendingStatements(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transactionTerminated(boolean commit) throws SQLException {
        try {
            if (commit) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.logInfo(this + ": committing on connection...");
                }
                this.wrapped.commit();
            } else {
                this.forceCloseAllPendingStatements(false);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.logInfo(this + ": transaction aborting - " + "pessimistically closing all pending statements to avoid autoCommit after timeout");
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.logInfo(this + ": rolling back on connection...");
                }
                this.wrapped.rollback();
            }
        }
        catch (SQLException e) {
            this.pooledConnection.setErroneous();
            String msg = "Error in commit on vendor connection";
            if (!commit) {
                msg = "Error in rollback on vendor connection";
            }
            AtomikosSQLException.throwAtomikosSQLException(msg, e);
        }
        finally {
            this.resetForNextTransaction();
            this.markForReuseIfPossible();
        }
    }

    public void registerXPooledConnectionEventListener(XPooledConnectionEventListener l) {
        this.pooledConnection.registerXPooledConnectionEventListener(l);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("atomikos non-xa connection proxy for ");
        ret.append(this.wrapped);
        return ret.toString();
    }

    public boolean usesConnection(XPooledConnection xpc) {
        boolean ret = false;
        if (this.pooledConnection != null) {
            ret = ((Object)((Object)this.pooledConnection)).equals(xpc);
        }
        return ret;
    }

    public void addHeuristicMessage(HeuristicMessage hmsg) {
        if (this.participant != null) {
            this.participant.addHeuristicMessage(hmsg);
        }
    }
}

