/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.internal;

import com.atomikos.jdbc.internal.AbstractJdbcConnectionProxy;
import com.atomikos.jdbc.internal.AtomikosNonXAPooledConnection;
import com.atomikos.jdbc.internal.AtomikosSQLException;
import com.atomikos.jdbc.internal.NonXaConnectionProxy;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.Proxied;
import java.sql.Connection;
import java.sql.SQLException;

public class JtaUnawareThreadLocalConnection
extends AbstractJdbcConnectionProxy
implements NonXaConnectionProxy {
    private static final Logger LOGGER = LoggerFactory.createLogger(JtaUnawareThreadLocalConnection.class);
    private final AtomikosNonXAPooledConnection pooledConnection;
    private boolean dirty;

    public JtaUnawareThreadLocalConnection(AtomikosNonXAPooledConnection pooledConnection) {
        super(pooledConnection.getConnection());
        this.pooledConnection = pooledConnection;
    }

    @Override
    protected void updateTransactionContext() throws SQLException {
        if (!this.getAutoCommit()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(this + ": marking as dirty...");
            }
            this.dirty = true;
        }
    }

    @Override
    protected boolean isEnlistedInGlobalTransaction() {
        return false;
    }

    protected void handleInvocationException(Throwable e) throws Throwable {
        this.pooledConnection.setErroneous();
        throw e;
    }

    public String toString() {
        return "jtaUnawareThreadLocalConnection (isAvailable = " + this.isAvailableForReuseByPool() + ")  for vendor instance " + this.delegate;
    }

    @Override
    public void transactionTerminated(boolean committed) throws SQLException {
        AtomikosSQLException.throwAtomikosSQLException(this + ": transaction termination detected - which is incompatible with this type of connection???");
    }

    @Override
    public boolean isAvailableForReuseByPool() {
        return this.closed;
    }

    @Override
    @Proxied
    public void commit() throws SQLException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": commit on vendor connection...");
        }
        ((Connection)this.delegate).commit();
        this.dirty = false;
    }

    @Override
    @Proxied
    public void rollback() throws SQLException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": rollback on vendor connection...");
        }
        ((Connection)this.delegate).rollback();
        this.dirty = false;
    }

    @Proxied
    public void close() throws SQLException {
        if (this.dirty && !((Connection)this.delegate).getAutoCommit()) {
            try {
                this.rollback();
            }
            catch (Throwable t) {
                LOGGER.logWarning(this + ": unexpected error trying to rollback on vendor connection - marking connection as erroneous so it will be replaced by the pool...", t);
                this.pooledConnection.setErroneous();
            }
        }
        this.markClosed();
    }

    protected Class<Connection> getRequiredInterfaceType() {
        return Connection.class;
    }
}

