/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.nonxa;

import com.atomikos.jdbc.XPooledConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;

class NonXAPooledConnectionImp
implements XPooledConnection {
    private Connection connection;
    private Date lastUsed;
    private boolean invalidated;
    private ArrayList listeners;

    NonXAPooledConnectionImp(Connection wrapped) {
        this.connection = wrapped;
        this.invalidated = false;
        this.listeners = new ArrayList();
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public void close() throws SQLException {
        this.connection.close();
    }

    public void setLastUse(Date date) {
        this.lastUsed = date;
    }

    public Date getLastUse() {
        return this.lastUsed;
    }

    public void setInvalidated() {
        this.invalidated = true;
    }

    public boolean getInvalidated() {
        return this.invalidated;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    void notifyCloseListeners() {
        List list = (List)this.listeners.clone();
        Iterator all = list.iterator();
        ConnectionEvent event = new ConnectionEvent(this);
        while (all.hasNext()) {
            ConnectionEventListener l = (ConnectionEventListener)all.next();
            l.connectionClosed(event);
        }
    }
}

