/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.system.Configuration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.transaction.xa.XAResource;

class DefaultJtaMessageProducer
implements MessageProducer {
    private TransactionalResource res_;
    private XAResourceTransaction restx_;
    private XAResource xares_;
    private MessageProducer sender_;
    private String nameOfLastThreadToEnlist_;

    protected DefaultJtaMessageProducer(MessageProducer producer, TransactionalResource res, XAResource xares) {
        this.sender_ = producer;
        this.res_ = res;
        this.restx_ = null;
        this.xares_ = xares;
        this.nameOfLastThreadToEnlist_ = "";
    }

    protected MessageProducer getMessageProducer() {
        return this.sender_;
    }

    protected synchronized void enlist(HeuristicMessage msg) throws JMSException {
        String callingThreadName = Thread.currentThread().getName();
        if (this.restx_ != null) {
            String m = "JtaMessageProducer.enlist: already enlisted";
            if (!callingThreadName.equals(this.nameOfLastThreadToEnlist_)) {
                m = "JtaMessageProducer.enlist: Illegal multi-threaded use: object already enlisted by different thread [" + this.nameOfLastThreadToEnlist_ + "]";
            }
            throw new JMSException(m);
        }
        CompositeTransactionManager ctm = Configuration.getCompositeTransactionManager();
        if (ctm == null) {
            throw new JMSException("JTA MessageProducer: requires Atomikos TransactionsEssentials to be running! Please make sure to start a transaction first.");
        }
        CompositeTransaction ct = ctm.getCompositeTransaction();
        if (ct == null || ct.getProperty("com.atomikos.icatch.jta.transaction") == null) {
            throw new JMSException("JTA transaction required for JtaMessageProducer");
        }
        this.restx_ = (XAResourceTransaction)this.res_.getResourceTransaction(ct);
        this.restx_.setXAResource(this.xares_);
        this.restx_.resume();
        if (msg != null) {
            this.restx_.addHeuristicMessage(msg);
        }
        this.nameOfLastThreadToEnlist_ = callingThreadName;
    }

    protected synchronized void delist() throws JMSException {
        if (this.restx_ == null) {
            throw new JMSException("JtaMessageProducer.delist: not enlisted");
        }
        this.restx_.suspend();
        this.restx_ = null;
    }

    public void setDisableMessageID(boolean val) throws JMSException {
        this.sender_.setDisableMessageID(val);
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.sender_.getDisableMessageID();
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.sender_.setDisableMessageTimestamp(value);
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.sender_.getDisableMessageTimestamp();
    }

    public void setDeliveryMode(int mode) throws JMSException {
        this.sender_.setDeliveryMode(mode);
    }

    public int getDeliveryMode() throws JMSException {
        return this.sender_.getDeliveryMode();
    }

    public void setPriority(int p) throws JMSException {
        this.sender_.setPriority(p);
    }

    public int getPriority() throws JMSException {
        return this.sender_.getPriority();
    }

    public void setTimeToLive(long ttl) throws JMSException {
        this.sender_.setTimeToLive(ttl);
    }

    public long getTimeToLive() throws JMSException {
        return this.sender_.getTimeToLive();
    }

    public Destination getDestination() throws JMSException {
        return this.sender_.getDestination();
    }

    public void close() throws JMSException {
        this.sender_.close();
    }

    public void send(Message msg) throws JMSException {
        this.sendToDefaultDestination(msg, null);
    }

    public void send(Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.sendToDefaultDestination(msg, deliveryMode, priority, timeToLive, null);
    }

    public void send(Destination dest, Message msg) throws JMSException {
        StringHeuristicMessage hmsg = new StringHeuristicMessage("Sending of JMS Message with ID: " + msg.getJMSMessageID());
        this.sendToDestination(dest, msg, (HeuristicMessage)hmsg);
    }

    public void send(Destination dest, Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        StringHeuristicMessage hmsg = new StringHeuristicMessage("Sending of JMS Message with ID: " + msg.getJMSMessageID());
        this.sendToDestination(dest, msg, deliveryMode, priority, timeToLive, (HeuristicMessage)hmsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToDefaultDestination(Message msg, int deliveryMode, int priority, long timeToLive, HeuristicMessage hmsg) throws JMSException {
        this.enlist(hmsg);
        try {
            this.sender_.send(msg, deliveryMode, priority, timeToLive);
        }
        finally {
            this.delist();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToDefaultDestination(Message msg, HeuristicMessage hmsg) throws JMSException {
        this.enlist(hmsg);
        try {
            this.sender_.send(msg);
        }
        finally {
            this.delist();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToDestination(Destination dest, Message msg, int deliveryMode, int priority, long timeToLive, HeuristicMessage hmsg) throws JMSException {
        this.enlist(hmsg);
        try {
            this.sender_.send(dest, msg, deliveryMode, priority, timeToLive);
        }
        finally {
            this.delist();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToDestination(Destination dest, Message msg, HeuristicMessage hmsg) throws JMSException {
        this.enlist(hmsg);
        try {
            this.sender_.send(dest, msg);
        }
        finally {
            this.delist();
        }
    }
}

