/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.AbstractConnectionFactoryBean;
import com.atomikos.jms.MessageConsumerSession;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageListener;

public abstract class MessageConsumerSessionPool {
    private AbstractConnectionFactoryBean connectionFactoryBean;
    private MessageListener messageListener;
    private String user;
    private String password;
    private Destination destination;
    private int transactionTimeout;
    private int poolSize;
    private List sessions = new ArrayList();
    private boolean daemonThreads;
    private boolean notifyListenerOnClose = false;
    private String messageSelector;
    private ExceptionListener exceptionListener;

    protected MessageConsumerSessionPool() {
        this.setPoolSize(1);
    }

    protected void setAbstractConnectionFactoryBean(AbstractConnectionFactoryBean bean) {
        this.connectionFactoryBean = bean;
    }

    protected AbstractConnectionFactoryBean getAbstractConnectionFactoryBean() {
        return this.connectionFactoryBean;
    }

    protected Destination getDestination() {
        return this.destination;
    }

    protected void setDestination(Destination dest) {
        this.destination = dest;
    }

    public void setDaemonThreads(boolean value) {
        this.daemonThreads = value;
    }

    public boolean getDaemonThreads() {
        return this.daemonThreads;
    }

    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public String getUser() {
        return this.user;
    }

    public void setMessageListener(MessageListener listener) {
        this.messageListener = listener;
        Iterator it = this.sessions.iterator();
        while (it.hasNext()) {
            MessageConsumerSession s = (MessageConsumerSession)it.next();
            s.setMessageListener(listener);
        }
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setTransactionTimeout(int i) {
        this.transactionTimeout = i;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String selector) {
        this.messageSelector = selector;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int i) {
        this.poolSize = i;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    protected abstract MessageConsumerSession createSession();

    protected abstract boolean getNoLocal();

    protected abstract String getSubscriberName();

    public void start() throws JMSException {
        if (this.destination == null) {
            throw new JMSException("MessageConsumerSessionPool: destination not specified");
        }
        if (this.connectionFactoryBean == null) {
            throw new JMSException("MessageConsumerSessionPool: factory not set");
        }
        if (this.messageListener == null) {
            throw new JMSException("MessageConsumerSessionPool: messageListener not set");
        }
        for (int i = 0; i < this.poolSize; ++i) {
            MessageConsumerSession s = this.createSession();
            s.setMessageListener(this.messageListener);
            s.setPassword(this.password);
            s.setUser(this.user);
            s.setDestination(this.destination);
            s.setAbstractConnectionFactoryBean(this.connectionFactoryBean);
            s.setTransactionTimeout(this.transactionTimeout);
            s.setDaemonThreads(this.daemonThreads);
            s.setNotifyListenerOnClose(this.notifyListenerOnClose);
            s.setMessageSelector(this.getMessageSelector());
            s.setExceptionListener(this.exceptionListener);
            if (this.getSubscriberName() != null) {
                s.setSubscriberName(this.getSubscriberName() + "-" + i);
            }
            s.setNoLocal(this.getNoLocal());
            try {
                s.startListening();
            }
            catch (Exception e) {
                Configuration.logWarning((String)"Error starting pool", (Throwable)e);
            }
            this.sessions.add(s);
        }
        this.setMessageListener(this.messageListener);
    }

    public void stop() {
        Iterator it = this.sessions.iterator();
        while (it.hasNext()) {
            MessageConsumerSession s = (MessageConsumerSession)it.next();
            s.stopListening();
        }
    }

    public boolean getNotifyListenerOnClose() {
        return this.notifyListenerOnClose;
    }

    public void setNotifyListenerOnClose(boolean b) {
        this.notifyListenerOnClose = b;
        Iterator it = this.sessions.iterator();
        while (it.hasNext()) {
            MessageConsumerSession s = (MessageConsumerSession)it.next();
            s.setNotifyListenerOnClose(b);
        }
    }
}

