/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.pool;

import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.Reapable;
import com.atomikos.datasource.pool.XPooledConnection;
import com.atomikos.datasource.pool.XPooledConnectionEventListener;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.system.Configuration;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractXPooledConnection
implements XPooledConnection {
    private long lastTimeAcquired = System.currentTimeMillis();
    private long lastTimeReleased = System.currentTimeMillis();
    private List poolEventListeners = new ArrayList();
    private Reapable currentProxy = null;
    private ConnectionPoolProperties props;

    protected AbstractXPooledConnection(ConnectionPoolProperties props) {
        this.props = props;
    }

    public long getLastTimeAcquired() {
        return this.lastTimeAcquired;
    }

    public long getLastTimeReleased() {
        return this.lastTimeReleased;
    }

    public synchronized Reapable createConnectionProxy(HeuristicMessage hmsg) throws CreateConnectionException {
        this.updateLastTimeAcquired();
        this.testUnderlyingConnection();
        this.currentProxy = this.doCreateConnectionProxy(hmsg);
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": returning proxy " + this.currentProxy));
        }
        return this.currentProxy;
    }

    public void reap() {
        if (this.currentProxy != null) {
            Configuration.logWarning((String)(this + ": reaping connection..."));
            this.currentProxy.reap();
        }
        this.updateLastTimeReleased();
    }

    public void registerXPooledConnectionEventListener(XPooledConnectionEventListener listener) {
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": registering listener " + listener));
        }
        this.poolEventListeners.add(listener);
    }

    public void unregisterXPooledConnectionEventListener(XPooledConnectionEventListener listener) {
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": unregistering listener " + listener));
        }
        this.poolEventListeners.remove(listener);
    }

    protected void fireOnXPooledConnectionTerminated() {
        for (int i = 0; i < this.poolEventListeners.size(); ++i) {
            XPooledConnectionEventListener listener = (XPooledConnectionEventListener)this.poolEventListeners.get(i);
            if (Configuration.isDebugLoggingEnabled()) {
                Configuration.logDebug((String)(this + ": notifying listener: " + listener));
            }
            listener.onXPooledConnectionTerminated(this);
        }
        this.updateLastTimeReleased();
    }

    protected String getTestQuery() {
        return this.props.getTestQuery();
    }

    protected void updateLastTimeReleased() {
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": updating last time released"));
        }
        this.lastTimeReleased = System.currentTimeMillis();
    }

    protected void updateLastTimeAcquired() {
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": updating last time acquired"));
        }
        this.lastTimeAcquired = System.currentTimeMillis();
    }

    protected Reapable getCurrentConnectionProxy() {
        return this.currentProxy;
    }

    public boolean canBeRecycledForCallingThread() {
        return false;
    }

    protected int getDefaultIsolationLevel() {
        return this.props.getDefaultIsolationLevel();
    }

    protected abstract Reapable doCreateConnectionProxy(HeuristicMessage var1) throws CreateConnectionException;

    protected abstract void testUnderlyingConnection() throws CreateConnectionException;
}

