/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa.session;

import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.session.BranchEndedStateHandler;
import com.atomikos.datasource.xa.session.BranchEnlistedStateHandler;
import com.atomikos.datasource.xa.session.InvalidSessionHandleStateException;
import com.atomikos.datasource.xa.session.NotInBranchStateHandler;
import com.atomikos.datasource.xa.session.TransactionContextStateHandler;
import com.atomikos.datasource.xa.session.UnexpectedTransactionContextException;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.system.Configuration;
import javax.transaction.xa.XAResource;

class BranchSuspendedStateHandler
extends TransactionContextStateHandler {
    private XAResourceTransaction branch;
    private CompositeTransaction ct;

    BranchSuspendedStateHandler(XATransactionalResource resource, XAResourceTransaction branch, CompositeTransaction ct, XAResource xaResource) {
        super(resource, xaResource);
        this.branch = branch;
        this.ct = ct;
    }

    TransactionContextStateHandler checkEnlistBeforeUse(CompositeTransaction ct, HeuristicMessage hmsg) throws InvalidSessionHandleStateException, UnexpectedTransactionContextException {
        String msg = "Detected illegal attempt to use a suspended XA session";
        Configuration.logWarning((String)msg);
        throw new InvalidSessionHandleStateException(msg);
    }

    TransactionContextStateHandler sessionClosed() {
        return new BranchEndedStateHandler(this.getXATransactionalResource(), this.branch, this.ct);
    }

    TransactionContextStateHandler transactionTerminated(CompositeTransaction tx) {
        NotInBranchStateHandler ret = null;
        if (this.ct.isSameTransaction(tx)) {
            ret = new NotInBranchStateHandler(this.getXATransactionalResource(), this.getXAResource());
        }
        return ret;
    }

    boolean isSuspendedInTransaction(CompositeTransaction tx) {
        boolean ret = false;
        if (tx != null && this.ct.isSameTransaction(tx)) {
            ret = true;
        }
        return ret;
    }

    public TransactionContextStateHandler transactionResumed() throws InvalidSessionHandleStateException {
        return new BranchEnlistedStateHandler(this.getXATransactionalResource(), this.ct, this.getXAResource(), this.branch);
    }
}

