/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.TxState;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;

class Sync2Sync
implements Synchronization {
    private static final long serialVersionUID = 2217827831174006366L;
    private static final Logger LOGGER = LoggerFactory.createLogger(Sync2Sync.class);
    private javax.transaction.Synchronization sync;
    private Boolean committed;

    Sync2Sync(javax.transaction.Synchronization sync) {
        this.sync = sync;
    }

    public void beforeCompletion() {
        this.sync.beforeCompletion();
        this.resetForReuse();
        LOGGER.logDebug("beforeCompletion() called on Synchronization: " + this.sync.toString());
    }

    private void resetForReuse() {
        this.committed = null;
    }

    public void afterCompletion(TxState state) {
        if (state == TxState.TERMINATED) {
            if (this.committed == null) {
                this.sync.afterCompletion(5);
                LOGGER.logDebug("afterCompletion ( STATUS_UNKNOWN ) called  on Synchronization: " + this.sync.toString());
            } else {
                boolean commit = this.committed;
                if (commit) {
                    this.sync.afterCompletion(3);
                    LOGGER.logDebug("afterCompletion ( STATUS_COMMITTED ) called  on Synchronization: " + this.sync.toString());
                } else {
                    this.sync.afterCompletion(4);
                    LOGGER.logDebug("afterCompletion ( STATUS_ROLLEDBACK ) called  on Synchronization: " + this.sync.toString());
                }
            }
        } else if (state == TxState.COMMITTING) {
            this.committed = Boolean.TRUE;
        } else if (state == TxState.ABORTING) {
            this.committed = Boolean.FALSE;
        }
    }
}

