/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.icatch.jta.UserTransactionServerImp;
import com.atomikos.icatch.provider.ConfigProperties;
import com.atomikos.icatch.provider.TransactionServicePlugin;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.Properties;

public class JtaTransactionServicePlugin
implements TransactionServicePlugin {
    private static Logger LOGGER = LoggerFactory.createLogger(JtaTransactionServicePlugin.class);
    public static final String AUTOMATIC_RESOURCE_REGISTRATION_PROPERTY_NAME = "com.atomikos.icatch.automatic_resource_registration";
    public static final String DEFAULT_JTA_TIMEOUT_PROPERTY_NAME = "com.atomikos.icatch.default_jta_timeout";
    public static final String SERIAL_JTA_TRANSACTIONS_PROPERTY_NAME = "com.atomikos.icatch.serial_jta_transactions";
    public static final String CLIENT_DEMARCATION_PROPERTY_NAME = "com.atomikos.icatch.client_demarcation";
    private boolean autoRegisterResources;

    public void beforeInit(Properties properties) {
        ConfigProperties configProperties = new ConfigProperties(properties);
        long defaultTimeoutInMillis = configProperties.getAsLong(DEFAULT_JTA_TIMEOUT_PROPERTY_NAME);
        int defaultJtaTimeout = 0;
        defaultJtaTimeout = (int)defaultTimeoutInMillis / 1000;
        if (defaultJtaTimeout <= 0) {
            LOGGER.logWarning("WARNING: com.atomikos.icatch.default_jta_timeout should be more than 1000 milliseconds - resetting to 10000 milliseconds instead...");
            defaultJtaTimeout = 10;
        }
        TransactionManagerImp.setDefaultTimeout(defaultJtaTimeout);
        boolean defaultSerial = configProperties.getAsBoolean(SERIAL_JTA_TRANSACTIONS_PROPERTY_NAME);
        TransactionManagerImp.setDefaultSerial(defaultSerial);
        boolean clientDemarcation = configProperties.getAsBoolean(CLIENT_DEMARCATION_PROPERTY_NAME);
        if (clientDemarcation) {
            String name = configProperties.getTmUniqueName();
            UserTransactionServerImp utxs = UserTransactionServerImp.getSingleton();
            utxs.init(name, properties);
        }
        this.autoRegisterResources = configProperties.getAsBoolean(AUTOMATIC_RESOURCE_REGISTRATION_PROPERTY_NAME);
    }

    public void afterShutdown() {
        UserTransactionServerImp.getSingleton().shutdown();
        TransactionManagerImp.installTransactionManager(null, false);
    }

    public void afterInit() {
        TransactionManagerImp.installTransactionManager(Configuration.getCompositeTransactionManager(), this.autoRegisterResources);
    }
}

