/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.xa.session.SessionHandleState;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.ConsumerProducerSupport;
import com.atomikos.jms.HeuristicMessageProducer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;

class AtomikosJmsMessageProducerProxy
extends ConsumerProducerSupport
implements HeuristicMessageProducer {
    private MessageProducer delegate;

    AtomikosJmsMessageProducerProxy(MessageProducer delegate, SessionHandleState state) {
        super(state);
        this.delegate = delegate;
    }

    public void send(Message msg, String heuristicMessage) throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": send ( message , heuristicMessage )...");
        }
        this.enlist(heuristicMessage);
        this.delegate.send(msg);
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": send done.");
        }
    }

    public void send(Destination dest, Message msg, String heuristicMessage) throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": send ( destination , message , heuristicMessage )...");
        }
        this.enlist(heuristicMessage);
        this.delegate.send(dest, msg);
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": send done.");
        }
    }

    public void send(Message msg, int deliveryMode, int priority, long timeToLive, String heuristicMessage) throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": send ( message , deliveryMode , priority , timeToLive , heuristicMessage )...");
        }
        this.enlist(heuristicMessage);
        this.delegate.send(msg, deliveryMode, priority, timeToLive);
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": send done.");
        }
    }

    public void send(Destination dest, Message msg, int deliveryMode, int priority, long timeToLive, String heuristicMessage) throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": send ( destination , message , deliveryMode , priority , timeToLive , heuristicMessage )...");
        }
        this.enlist(heuristicMessage);
        this.delegate.send(dest, msg, deliveryMode, priority, timeToLive);
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": send done.");
        }
    }

    public void close() throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": close...");
        }
        this.delegate.close();
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": close done.");
        }
    }

    public int getDeliveryMode() throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": getDeliveryMode()...");
        }
        int ret = this.delegate.getDeliveryMode();
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": getDeliveryMode() returning " + ret);
        }
        return ret;
    }

    public Destination getDestination() throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": getDestination()...");
        }
        Destination ret = this.delegate.getDestination();
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": getDestination() returning " + ret);
        }
        return ret;
    }

    public boolean getDisableMessageID() throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": getDisableMessageID()...");
        }
        boolean ret = this.delegate.getDisableMessageID();
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": getDisableMessageID() returning " + ret);
        }
        return ret;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": getDisableMessageTimestamp()...");
        }
        boolean ret = this.delegate.getDisableMessageTimestamp();
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": getDisableMessageTimestamp() returning " + ret);
        }
        return ret;
    }

    public int getPriority() throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": getPriority()...");
        }
        int ret = this.delegate.getPriority();
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": getPriority() returning " + ret);
        }
        return ret;
    }

    public long getTimeToLive() throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": getTimeToLive()...");
        }
        long ret = this.delegate.getTimeToLive();
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": getTimeToLive() returning " + ret);
        }
        return ret;
    }

    public void send(Message msg) throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": send ( message )...");
        }
        this.send(msg, null);
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": send done.");
        }
    }

    public void send(Destination dest, Message msg) throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": send ( destination , message )...");
        }
        this.send(dest, msg, null);
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": send done.");
        }
    }

    public void send(Message msg, int deliveryMode, int pty, long ttl) throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": send ( message , deliveryMode , priority , timeToLive )...");
        }
        this.send(msg, deliveryMode, pty, ttl, null);
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": send done.");
        }
    }

    public void send(Destination dest, Message msg, int mode, int pty, long ttl) throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": send ( destination , message , deliveryMode , priority , timeToLive )...");
        }
        this.send(dest, msg, mode, pty, ttl, null);
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": send done.");
        }
    }

    public void setDeliveryMode(int mode) throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": setDeliveryMode ( " + mode + " )...");
        }
        this.delegate.setDeliveryMode(mode);
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": setDeliveryMode done.");
        }
    }

    public void setDisableMessageID(boolean mode) throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": setDisableMessageID ( " + mode + " )...");
        }
        this.delegate.setDisableMessageID(mode);
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": setDisableMessageID done.");
        }
    }

    public void setDisableMessageTimestamp(boolean mode) throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": setDisableMessageTimestamp ( " + mode + " )...");
        }
        this.delegate.setDisableMessageTimestamp(mode);
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": setDisableMessageTimestamp done.");
        }
    }

    public void setPriority(int pty) throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": setPriority ( " + pty + " )...");
        }
        this.delegate.setPriority(pty);
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": setPriority done.");
        }
    }

    public void setTimeToLive(long ttl) throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": setTimeToLive ( " + ttl + " )...");
        }
        this.delegate.setTimeToLive(ttl);
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": setTimeToLive done.");
        }
    }

    public String toString() {
        return "atomikos MessageProducer proxy for " + this.delegate;
    }
}

